DELIMITER $$

DROP PROCEDURE IF EXISTS V202001091505__CreateInvoiceCurrencyTable $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001091505__CreateInvoiceCurrencyTable()

BEGIN
  
  -- Add the email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='invoice_currency' )) THEN
    
	CREATE TABLE `invoice_currency` (
  `id` bigint(100) NOT NULL AUTO_INCREMENT,
  `invoiceCurrencyName` varchar(100) NOT NULL,
  `invoiceCurrencyCode` varchar(10) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_invoice_currency_to_user_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_invoice_currency_to_user` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
	
  END IF;

END $$

-- Execute the stored procedure
CALL V202001091505__CreateInvoiceCurrencyTable() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001091505__CreateInvoiceCurrencyTable $$
 
DELIMITER ;