DELIMITER $$

DROP PROCEDURE IF EXISTS academylocationkohaCategory $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE academylocationkohaCategory()

BEGIN
  
  -- Add the email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='academy_location_koha_category' )) THEN
    
	CREATE TABLE `academy_location_koha_category` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `academyLocationId` bigint(20) NOT NULL,
  `categoryId` int(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_academy_location_koha_categories_1_idx` (`academyLocationId`),
  KEY `fk_academy_location_koha_categories_2_idx` (`categoryId`),
  KEY `fk_academy_location_kkoha_categories_3_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_academy_location_koha_categories_1` FOREIGN KEY (`academyLocationId`) REFERENCES `academy_location` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_academy_location_koha_categories_2` FOREIGN KEY (`categoryId`) REFERENCES `koha_categories` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `fk_academy_location_koha_categories_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=87 DEFAULT CHARSET=utf8;
	
  END IF;
  

END $$

-- Execute the stored procedure
CALL academylocationkohaCategory $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS academylocationkohaCategory $$
 
DELIMITER ;