DELIMITER $$

DROP PROCEDURE IF EXISTS V202001171148__AlterCurrencyTable $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001171148__AlterCurrencyTable()

BEGIN
  
  -- Add the email_address column to the email table, if it doesn't already exist
  
   IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='currency' 
  AND column_name='status')) THEN
	ALTER TABLE `currency` ADD COLUMN `status` BIT(1) NOT NULL DEFAULT 1 AFTER `currencyCode`;
  END IF;

END $$

-- Execute the stored procedure
CALL V202001171148__AlterCurrencyTable() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001171148__AlterCurrencyTable $$
 
DELIMITER ;