DELIMITER $$
DROP PROCEDURE IF EXISTS V202001221213__AlterBillHeader $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001221213__AlterBillHeader()

BEGIN
  
  -- Add the email_address column to the email table, if it doesn't already exist
  
 IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='bill_header' 
  AND column_name='orgCurrencyId')) THEN
	ALTER TABLE `bill_header` 
		ADD COLUMN `orgCurrencyId` BIGINT(10) NULL DEFAULT NULL AFTER `billCurrencyId`,
		ADD INDEX `fk_bill_header_bill_currency_to_currency_idx` (`billCurrencyId` ASC),
		ADD INDEX `fk_bill_header_org_currency_to_currency_idx` (`orgCurrencyId` ASC);
	ALTER TABLE `bill_header` 
		ADD CONSTRAINT `fk_bill_header_bill_currency_to_currency`
  			FOREIGN KEY (`billCurrencyId`)
  			REFERENCES `currency` (`id`)
  			ON DELETE RESTRICT
  			ON UPDATE RESTRICT,
		ADD CONSTRAINT `fk_bill_header_org_currency_to_currency`
 			FOREIGN KEY (`orgCurrencyId`)
  			REFERENCES `currency` (`id`)
  			ON DELETE RESTRICT
  			ON UPDATE RESTRICT;
 END IF;

END $$

-- Execute the stored procedure
CALL V202001221213__AlterBillHeader() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001221213__AlterBillHeader $$
 
DELIMITER ;