DELIMITER $$

DROP PROCEDURE IF EXISTS V202002062114__Insert_settlement_UI_Bill_ReceiptTranslation $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202002062114__Insert_settlement_UI_Bill_ReceiptTranslation()

BEGIN
  
  -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName="FEEANDPAYMENTS" and keyName="PERFORM_SETTELEMENT_IN_CREATED_CURRENCY" )) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('FEEANDPAYMENTS','PERFORM_SETTELEMENT_IN_CREATED_CURRENCY','Perform Settlement in Created Currency','Perform Settlement in Created Currency',now(),1);
  END IF;
  
  IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName="FEEANDPAYMENTS" and keyName="PERFORM_SETTELEMENT_IN_BASE_CURRENCY" )) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('FEEANDPAYMENTS','PERFORM_SETTELEMENT_IN_BASE_CURRENCY','Perform Settlement in Academy Location Base Currency','Perform Settlement in Academy Location Base Currency',now(),1);
  END IF;
  
  IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName="FEEANDPAYMENTS" and keyName="CONVERTED_BALANCE_AMOUNT" )) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('FEEANDPAYMENTS','CONVERTED_BALANCE_AMOUNT','Converted Balance Amount','Converted Balance Amount',now(),1);
  END IF;

END $$

-- Execute the stored procedure
CALL V202002062114__Insert_settlement_UI_Bill_ReceiptTranslation() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202002062114__Insert_settlement_UI_Bill_ReceiptTranslation $$
 
DELIMITER ;