DELIMITER $$

DROP PROCEDURE IF EXISTS InsertTimeTableKeyForTranslation $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE InsertTimeTableKeyForTranslation()

BEGIN
  
  -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName = 'TRANSLATIONS'  and keyName = 'EXPORT_TIMETABLE')) THEN
    
	INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('TRANSLATIONS','EXPORT_TIMETABLE','Export Timetable','Export Timetable',now(),1);

  END IF;

END $$

-- Execute the stored procedure
CALL InsertTimeTableKeyForTranslation() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS InsertTimeTableKeyForTranslation $$
 
DELIMITER ;