DELIMITER $$
DROP PROCEDURE IF EXISTS V202002141840__Create_Application_Export_All_View $$
CREATE PROCEDURE V202002141840__Create_Application_Export_All_View()
BEGIN
DROP VIEW IF EXISTS application_export_all_view;
IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='application_export_all_view')) THEN 
CREATE 
   VIEW `application_export_all_view` AS
    select 
        `t3`.`code` AS `APPLICATION_ID`,
        `t2`.`printName` AS `FULL_NAME`,
        `t2`.`firstName` AS `FIRST_NAME`,
        `t2`.`middleName` AS `MIDDLE_NAME`,
        `t2`.`lastName` AS `LAST_NAME`,
        `t20`.`academyName` AS `ACADEMY`,
        `t19`.`locationName` AS `LOCATION`,
        `t5`.`programName` AS `PROGRAM_NAME`,
        `t15`.`batchName` AS `BATCH`,
        `t15`.`id` AS `BATCH_ID`,
        `t8`.`seatName` AS `SEAT_TYPE`,
        `t8`.`id` AS `SEAT_TYPE_ID`,
        `t54`.`printName` AS `APPLICATION_OWNER`,
        `t52`.`whetherHostelApplicable` AS `HOSTEL_REQUIRED`,
        `t59`.`defaultValue` AS `APPLICATION_VIEW_STATUS`,
        `t51`.`value` AS `PROGRAM_WITHDRAWN_REASON`,
        `t57`.`defaultValue` AS `PROGRAM_VIEW_STATUS`,
        `t12`.`stageName` AS `CURRENT_STAGE`,
        `t1`.`offerLetterAcceptanceDate` AS `OFFER_LETTER_ACCEPTANCE_DATE`,
        `t61`.`defaultValue` AS `STAGE_VIEW_STATUS`,
        `t58`.`defaultValue` AS `ADMISSION_VIEW_STATUS`,
        `t3`.`applicationCreationSource` AS `APPLICATION_CREATION_SOURCE`,
        `t50`.`printName` AS `APPROVED_PERSON`,
        `t3`.`applicationApprovedOn` AS `APPLICATION_APPROVED_DATE`,
        `t3`.`applicationCreatedOn` AS `APPLICATION_DATE`,
        `t43`.`firstName` AS `FATHERS_FULL_NAME`,
        `t43`.`firstName` AS `FATHERS_FIRST_NAME`,
        `t43`.`middleName` AS `FATHERS_MIDDLE_NAME`,
        `t43`.`lastName` AS `FATHERS_LAST_NAME`,
        `t48`.`firstName` AS `MOTHERS_FULL_NAME`,
        `t48`.`firstName` AS `MOTHERS_FIRST_NAME`,
        `t48`.`middleName` AS `MOTHERS_MIDDLE_NAME`,
        `t48`.`lastName` AS `MOTHERS_LAST_NAME`,
        `t27`.`beneficiaryName` AS `BENEFICIARY_NAME`,
        `t27`.`accountNumber` AS `ACCOUNT_NUMBER`,
        `t27`.`accountType` AS `ACCOUNT_TYPE`,
        `t27`.`bankName` AS `BANK_NAME`,
        `t27`.`branchName` AS `BRANCH_NAME`,
        `t27`.`IFSCode` AS `IFSCODE`,
        `t2`.`birthDate` AS `DATE_OF_BIRTH`,
        `t62`.`itemValue` AS `GENDER`,
        `t2`.`category` AS `CATEGORY`,
        `t2`.`emailId` AS `EMAIL`,
        `t2`.`mobileCountryCode` AS `MOBILE_COUNTRY_CODE`,
        `t2`.`mobileNumber` AS `MOBILE_NUMBER`,
        `t2`.`phoneCountryCode` AS `PHONE_COUNTRY_CODE`,
        `t2`.`phoneAreaCode` AS `PHONE_AREA_CODE`,
        `t2`.`phoneNo` AS `PHONE_NO`,
        `t2`.`bloodGroup` AS `BLOOD_GROUP`,
        `t45`.`itemValue` AS `RELIGION`,
        `t46`.`itemValue` AS `CASTE_CATEGORY`,
        `t2`.`comments` AS `APPLICATION_GRID_COMMENTS`,
        `t10`.`whetherFeePlanApplicable` AS `WHETHER_FEE_PLAN_APPLICABLE`,
        `t44`.`billStatus` AS `BILL_STATUS`,
        `t59`.`defaultValue` AS `APPLICATION_STATUS`,
        `t57`.`defaultValue` AS `PROGRAM_STATUS`,
        `t61`.`defaultValue` AS `STAGE_STATUS`,
        `t60`.`defaultValue` AS `ADMISSION_STATUS`,
        `t53`.`countryName` AS `COUNTRY`,
        `t49`.`itemValue` AS `NATIONALITY`,
        `t2`.`nationalID` AS `NATIONAL_ID`,
        `t2`.`printName` AS `APPLICATION_PERSON_PRINTNAME`,
        `t2`.`id` AS `APPLICATION_PERSON_ID`,
        `t14`.`id` AS `ADMISSION_PRIMERY_ID`,
        `t3`.`id` AS `APPLICATION_PRIMERY_ID`,
        `t1`.`id` AS `APPLICATION_PROGRAM_ID`,
        `t7`.`id` AS `PROG_BATCH_SEAT_CONFIG_ID`,
        `t1`.`academyLocationId` AS `ACADEMY_LOCATION_ID`,
        `t3`.`id` AS `ID`,
        `t26`.`externalUserId` AS `EXTERNAL_USER_ID`,
        `t7`.`id` AS `IS_OFFER_LETTER_APPLICABLE`,
        `t56`.`printName` AS `FOLLOW_UP_USER`
    from
        (((((((((((((((((((((((((((((((((((`application` `t3`
        left join `users` `t54` ON ((`t54`.`id` = `t3`.`applicationOwner`)))
        join `applicant_person` `t2` ON ((`t2`.`id` = `t3`.`applicantPersonId`)))
        left join `application_program` `t1` ON ((`t3`.`id` = `t1`.`applicationId`)))
        left join `users` `t50` ON ((`t50`.`id` = `t3`.`applicationApprovedBy`)))
        left join `external_user_association` `t26` ON (((`t3`.`id` = `t26`.`applicationId`)
            and (`t26`.`referencyEntityType` = 'APPLICATION'))))
        left join `applicant_person_relationships` `t47` ON (((`t47`.`applicantPersonId` = `t2`.`id`)
            and (`t47`.`relationship` = 'MOTHER')
            and (`t47`.`whetherDeleted` = 0))))
        left join `applicant_person_relationships` `t42` ON (((`t42`.`applicantPersonId` = `t2`.`id`)
            and (`t42`.`relationship` = 'FATHER')
            and (`t42`.`whetherDeleted` = 0))))
        left join `country` `t53` ON ((`t2`.`countryId` = `t53`.`id`)))
        left join `religions` `t45` ON ((`t2`.`religionId` = `t45`.`id`)))
        left join `applicant_bank_details` `t27` ON ((`t2`.`bankDetailId` = `t27`.`id`)))
        left join `nationalities` `t49` ON ((`t2`.`nationalityId` = `t49`.`id`)))
        left join `applicant_hostel_requirement` `t52` ON (((`t52`.`applicantPersonId` = `t2`.`id`)
            and (`t52`.`whetherDeleted` = 0))))
        left join `caste_categories` `t46` ON ((`t2`.`casteCategoryId` = `t46`.`id`)))
        left join `academy_location` `t4` ON ((`t4`.`id` = `t1`.`academyLocationId`)))
        left join `programs` `t5` ON ((`t5`.`id` = `t1`.`programId`)))
        left join `prog_batch_seat_config` `t7` ON ((`t7`.`id` = `t1`.`progBatchSeatConfigId`)))
        left join `application_prog_withdraw_reasons` `t51` ON ((`t51`.`id` = `t1`.`withdrawl_reason_id`)))
        left join `application_admission_detail` `t18` ON ((`t18`.`applicationProgramId` = `t1`.`id`)))
        left join `program_slctn_process_stages` `t10` ON ((`t10`.`id` = `t1`.`currentStageId`)))
        left join `applicant_person` `t48` ON (((`t48`.`id` = `t47`.`relatedApplicantPersonId`)
            and (`t47`.`relationship` = 'MOTHER')
            and (`t47`.`whetherDeleted` = 0))))
        left join `applicant_person` `t43` ON (((`t43`.`id` = `t42`.`relatedApplicantPersonId`)
            and (`t42`.`relationship` = 'FATHER')
            and (`t42`.`whetherDeleted` = 0))))
        left join `locations` `t19` ON ((`t19`.`id` = `t4`.`locationId`)))
        left join `academies` `t20` ON ((`t20`.`id` = `t4`.`academyId`)))
        left join `batches` `t15` ON ((`t15`.`id` = `t7`.`programBatchId`)))
        left join `seat_types` `t8` ON ((`t8`.`id` = `t7`.`seatTypeId`)))
        left join `admission` `t14` ON ((`t14`.`applicationAdmissionId` = `t18`.`id`)))
        left join `application_prog_stage` `t9` ON (((`t9`.`applicationProgramId` = `t1`.`id`)
            and (`t9`.`programSelectionProcessStageId` = `t10`.`id`))))
        left join `slctn_process_stage` `t11` ON ((`t11`.`id` = `t10`.`selectionProcessStageId`)))
        left join `bill_header` `t44` ON ((`t44`.`applicationProgramStageId` = `t9`.`id`)))
        left join `selection_stage` `t12` ON ((`t12`.`id` = `t11`.`stageId`)))
        left join `ui_translation` `t57` ON (((`t57`.`keyName` = `t1`.`currentStatus`)
            and (`t57`.`objectName` = 'Admission'))))
        left join `ui_translation` `t58` ON (((`t58`.`keyName` = `t18`.`status`)
            and (`t58`.`objectName` = 'Admission'))))
        left join `ui_translation` `t59` ON (((`t59`.`keyName` = `t3`.`currentStatus`)
            and (`t59`.`objectName` = 'Admission'))))
        left join `ui_translation` `t60` ON (((`t60`.`keyName` = `t14`.`status`)
            and (`t60`.`objectName` = 'Admission'))))
        left join `ui_translation` `t61` ON (((`t61`.`keyName` = `t9`.`currentStatus`)
            and (`t61`.`objectName` = 'Admission'))))
        left join `application_followup` `t55` ON ((`t55`.`applicationId` = `t3`.`id`))
        left join `users` `t56` ON ((`t56`.`id` = `t55`.`userId`))
        left join `gender` `t62` ON ((`t62`.`id` = `t2`.`genderId`))
    where
        ((`t3`.`code` is not null)
            and (`t3`.`currentStatus` <> 'SOLD')
            and (`t3`.`currentStatus` not in ('DIRECT_SUBMISSION_TOKEN_GENERATED' , 'FORM_SALE_TOKEN_GENERATED')))
    order by `t3`.`applicationCreatedOn` desc;
END IF;
END $$
CALL V202002141840__Create_Application_Export_All_View $$ 
DROP PROCEDURE IF EXISTS V202002141840__Create_Application_Export_All_View $$ 
DELIMITER ;