DELIMITER $$
DROP PROCEDURE IF EXISTS V20200311123217__Create_application_reviewer $$
CREATE PROCEDURE V20200311123217__Create_application_reviewer()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='application_reviewer')) THEN 
CREATE TABLE `application_reviewer` (
	  `id` bigint(20) NOT NULL AUTO_INCREMENT,	 
	  `applicationId` bigint(20) DEFAULT NULL,
	  `reviewerId` bigint(20) DEFAULT NULL,	 
	  `lastUpdatedBy` bigint(20) NOT NULL,
	  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,	 
	   PRIMARY KEY (`id`),
	   UNIQUE KEY (`applicationId`,`reviewerId`),
	   CONSTRAINT `fk_application_reviewer_applicationId` FOREIGN KEY (`applicationId`) REFERENCES `application` (`id`),
	   CONSTRAINT `fk_application_reviewer_reviewerId` FOREIGN KEY (`reviewerId`) REFERENCES `users` (`id`),
	   CONSTRAINT `fk_application_reviewer_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)	   
	  );
	  
END IF; 

END $$
CALL V20200311123217__Create_application_reviewer () $$ 
DROP PROCEDURE IF EXISTS V20200311123217__Create_application_reviewer $$ 
DELIMITER ;