DELIMITER $$
DROP PROCEDURE IF EXISTS V20200323173204__Create_galleryUser $$
CREATE PROCEDURE V20200323173204__Create_galleryUser()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='gallery_users')) THEN 
CREATE TABLE `gallery_users` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `galleryId` BIGINT(20) NULL DEFAULT NULL,
  `userId` BIGINT(20) NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) NULL DEFAULT NULL,
  `lastUpdate` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  `galleryBatchMappingId` BIGINT(20) NULL DEFAULT NULL ,
  `version` BIGINT(20) NOT NULL,
 
  PRIMARY KEY (`id`),
  INDEX `fk_galler_idx` (`galleryId` ASC),
  INDEX `fk_gallery_users_idx` (`userId` ASC),
  INDEX `fk_last_updated_by_users_idx` (`lastUpdatedBy` ASC),
  INDEX `fk_gallery_batch_Mapping_idx` (`galleryBatchMappingId` ASC),
  CONSTRAINT `fk_galler`
    FOREIGN KEY (`galleryId`)
    REFERENCES `gallery` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_galler_users`
    FOREIGN KEY (`userId`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_last_updat_by_users`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT  `fk_gallery_batch_Mapping`
  FOREIGN KEY (`galleryBatchMappingId`)
  REFERENCES `gallery_batch_mapping` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT
    );
END IF; 

END $$
CALL V20200323173204__Create_galleryUser () $$ 
DROP PROCEDURE IF EXISTS V20200323173204__Create_galleryUser $$ 
DELIMITER ;