DELIMITER $$
DROP PROCEDURE IF EXISTS V20200511202138__Create_add_d2Flyway $$
CREATE PROCEDURE V20200511202138__Create_add_d2Flyway()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_type` WHERE typeName = 'Planning Reports' )) THEN
INSERT INTO `report_type` (`typeName`) VALUES ('Planning Reports'); 
END IF;	
	
IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'D2_TEACHING_PLAN' )) THEN 

set @reportType = (select id from report_type WHERE typeName = 'Planning Reports');

INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@reportType, 'D2_TEACHING_PLAN', 'D2 - Teaching Plan', 'D2_TEACHING_PLAN.png', 'D2_TEACHING_PLAN_CommonReport_Landscape.jasper', 'All', '1', 'D2_FooterBlank_Landscape.jasper', 'D2_FooterBlank_Landscape.jasper', '1', '1', 'D2_TEACHING_PLAN.jasper', 'AcademiaLogo.png'); 

set @d2TeachingPlan = (select max(id) from report_template where templateCode ='D2_TEACHING_PLAN');

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@d2TeachingPlan, 'TRANS_D2', 'D2 labels', '1', NOW()),
(@d2TeachingPlan, 'TRANS_BOARD_NAME', 'Maharashtra State Board of Technical Education', '1', NOW()),
(@d2TeachingPlan, 'TRANS_PLAN_NAME', 'LABORATORY ASSIGNMENT/ SHEET/ JOB/ PROJECT ACTIVITY PLANNING (LP)', '1', NOW()),
(@d2TeachingPlan, 'TRANS_ACADEMIC_YEAR', 'Academic Year:', '1', NOW()),
(@d2TeachingPlan, 'TRANS_PROGRAM', 'Program:', '1', NOW()),
(@d2TeachingPlan, 'TRANS_SEMESTER', 'Semester:', '1', NOW()),
(@d2TeachingPlan, 'TRANS_FACULTY_NAME', 'Name of Faculty:', '1', NOW()),
(@d2TeachingPlan, 'TRANS_COURSE_CODE', 'Course Code:', '1', NOW()),
(@d2TeachingPlan, 'TRANS_COURSE', 'Course:', '1', NOW()),
(@d2TeachingPlan, 'TRANS_SECTION', 'Section:', '1', NOW()),
(@d2TeachingPlan, 'TRANS_SR_NO.', 'Sr. No.', '1', NOW()),
(@d2TeachingPlan, 'TRANS_FROM', 'From', '1', NOW()),
(@d2TeachingPlan, 'TRANS_TO', 'To', '1', NOW()),
(@d2TeachingPlan, 'TRANS_CO', 'CO', '1', NOW()),
(@d2TeachingPlan, 'TRANS_PRO', 'PrO', '1', NOW()),
(@d2TeachingPlan, 'TRANS_EXPERIMENT_NAME', 'Name of Experiment/ Assignment/Sheet/Job/Project Activity', '1', NOW()),
(@d2TeachingPlan, 'TRANS_PLANED_DATE', 'Planned Date', '1', NOW()),
(@d2TeachingPlan, 'TRANS_ACTUAL_DATE', 'Actual Dates', '1', NOW()),
(@d2TeachingPlan, 'TRANS_REMARKS', 'Remarks', '1', NOW()),
(@d2TeachingPlan, 'TRANS_FACULTY_SIGNATURE', '(Name & Signature of Faculty)', '1', NOW()),
(@d2TeachingPlan, 'TRANS_HOD_SIGNATURE', '(Name & Signature of HOD)', '1', NOW());
END IF; 

END $$
CALL V20200511202138__Create_add_d2Flyway () $$ 
DROP PROCEDURE IF EXISTS V20200511202138__Create_add_d2Flyway $$ 
DELIMITER ;
