DELIMITER $$
DROP PROCEDURE IF EXISTS V20200512162434__Insert_messageTypetranslation $$
CREATE PROCEDURE V20200512162434__Insert_messageTypetranslation()
BEGIN

IF EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='ui_translation')) THEN 

  -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='EMAIL_ONLY')) THEN
    
	INSERT INTO `ui_translation` (`id`, `objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `lastUpdate`, `lastUpdatedBy`) VALUES (NULL, 'TRANSLATIONS', 'EMAIL_ONLY', 'Email ', 'Email ', now(), '1');
 END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='SYSTEM_NOTIFICATION')) THEN
    
	INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `lastUpdate`, `lastUpdatedBy`) VALUES ('TRANSLATIONS', 'SYSTEM_NOTIFICATION', 'System Internal Notification', 'System Internal Notification', now(), '1');

  END IF;
  
IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='PUSH_NOTIFICATION_ONLY')) THEN
    INSERT INTO `ui_translation` (`objectName`, `keyName`, `defaultValue`, `customerDefineValue`, `lastUpdate`, `lastUpdatedBy`) VALUES ('TRANSLATIONS', 'PUSH_NOTIFICATION_ONLY', 'Push Notification', 'Push Notification', now(), '1');

  END IF; 
END IF; 

END $$
CALL V20200512162434__Insert_messageTypetranslation() $$
DROP PROCEDURE IF EXISTS V20200512162434__Insert_messageTypetranslation $$
DELIMITER ;