DELIMITER $$
DROP PROCEDURE IF EXISTS V20200720122317__Create_receipt_view_sapb1 $$
CREATE PROCEDURE V20200720122317__Create_receipt_view_sapb1()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='receipt_view_sapb1')) THEN 
CREATE VIEW receipt_view_sapb1 AS
    SELECT 
        rh.voucherMode AS VoucherType,
        rh.receiptType AS ReceiptMode,
        rh.receiptNo AS ReceiptNo,
        rh.status AS ReceiptStatus,
        but.raiseBillType AS ReceiptType,
        but.billedUserType AS ReceiptFor,
        ou.code AS ReceivingIAU,
        c.currencyCode AS ReceivingCurrency,
        b.bankName AS OurBankAccount,
        rh.transactionDate AS ReceiptDate,
        CASE
            WHEN rh.applicantId IS NOT NULL THEN CONCAT(a.code, '/', ap.printName)
            WHEN rh.studentId IS NOT NULL THEN CONCAT(st_user.code, '/', st_user.printName)
            WHEN rh.sponsorId IS NOT NULL THEN CONCAT(sp.sponsorshipCode, '/', sp.sponsorName)
            WHEN rh.userId IS NOT NULL THEN CONCAT(u.code, '/', u.printName)
            ELSE NULL
        END AS ReceiptOwner,
        IFNULL(GROUP_CONCAT(fpm.paymentModeName), NULL) AS PaymentMode,
        IFNULL(GROUP_CONCAT(rpr.instrumentNo), NULL) AS InstrumentNo,
        IFNULL(GROUP_CONCAT(rpr.instrumentDate), NULL) AS InstrumentDate,
        rh.amount AS Amount,
        bdom.bankName AS DrawnOnBank,
        rh.narration AS Narration,
        (SELECT 
                GROUP_CONCAT(DISTINCT bh.billNo)
            FROM
                fee_adjustment_master fam
                    LEFT OUTER JOIN
                fee_adjustment_details fad ON fam.id = fad.adjustmentMasterId
                    LEFT OUTER JOIN
                bill_header bh ON bh.id = fad.billHeaderId
            WHERE
                fam.receiptHeaderId = rh.id) AS SettledDebitNote,
        rh.lastUpdate AS LastUpdate
    FROM
        receipt_header rh
            LEFT OUTER JOIN
        users u ON rh.userId = u.id
            LEFT OUTER JOIN
        sponsors sp ON rh.sponsorId = sp.id
            LEFT OUTER JOIN
        application a ON rh.applicantId = a.id
            LEFT OUTER JOIN
        applicant_person ap ON a.applicantPersonId = ap.id
            LEFT OUTER JOIN
        students st ON st.userId = rh.studentId
            LEFT OUTER JOIN
        users st_user ON rh.studentId = st_user.id
            LEFT OUTER JOIN
        persons p ON p.id = st.personId
            LEFT OUTER JOIN
        receipt_payment_instrument rpr ON rpr.receiptHeaderId = rh.id
            LEFT OUTER JOIN
        billed_user_type but ON but.id = rh.receiptFor
            LEFT OUTER JOIN
        organization_units ou ON rh.iauId = ou.id
            LEFT OUTER JOIN
        currency c ON c.id = rh.currencyId
            LEFT OUTER JOIN
        bank b ON b.id = rh.depositedBank
            LEFT OUTER JOIN
        fee_payment_modes fpm ON fpm.id = rpr.paymentMode
            LEFT OUTER JOIN
        bank_drawn_on_master bdom ON bdom.id = rpr.instrumentBank
    GROUP BY rh.id;
END IF; 

END $$
CALL V20200720122317__Create_receipt_view_sapb1 () $$ 
DROP PROCEDURE IF EXISTS V20200720122317__Create_receipt_view_sapb1 $$ 
DELIMITER ;