DELIMITER $$
DROP PROCEDURE IF EXISTS V20200812172845__Alter_OfflinePaymentHeader $$
CREATE PROCEDURE V20200812172845__Alter_OfflinePaymentHeader()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='offline_payment_header' AND column_name='applicationId')) THEN 
ALTER TABLE `offline_payment_header` 
ADD COLUMN `applicationId` BIGINT NULL DEFAULT NULL AFTER `lastUpdate`,
ADD INDEX `fk_offline_payment_header_to_application_idx` (`applicationId` ASC);

ALTER TABLE `offline_payment_header` 
ADD CONSTRAINT `fk_offline_payment_header_to_application`
  FOREIGN KEY (`applicationId`)
  REFERENCES `application` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;
END IF; 

END $$
CALL V20200812172845__Alter_OfflinePaymentHeader() $$
DROP PROCEDURE IF EXISTS V20200812172845__Alter_OfflinePaymentHeader $$
DELIMITER ;