DELIMITER $$

DROP PROCEDURE IF EXISTS V20200813121045__InsertUITranForSignup $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200813121045__InsertUITranForSignup()

BEGIN
  
   -- Insert new record in ui_translation table, if it doesn't already exist

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='VERIFICATION_REQUIRED')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','VERIFICATION_REQUIRED','Verification Required','Verification Required','Verifikasie word vereis', 'Yêu cầu xác minh',now(),1);
END IF;


IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='DOCUMENT_LIST')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('PORTAL_SETUP_NEW','DOCUMENT_LIST','Document List','Document List','Dokumentelys', 'Danh sách tài liệu',now(),1);
END IF;

SET SQL_SAFE_UPDATES=0;

IF EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='SELECTION_SNAPSORT')) THEN 
UPDATE `ui_translation` SET `keyName`='SELECTION_SNAPSHOT',defaultValue='Selection Snapshot',customerDefineValue='Selection Snapshot',
vietLanguage='Ảnh chụp nhanh lựa chọn',afriLanguage='Snapshot van keuse' WHERE objectName='PORTAL_SETUP_NEW' and keyName='SELECTION_SNAPSORT';
END IF; 
SET SQL_SAFE_UPDATES=1;
 
END $$

-- Execute the stored procedure
CALL V20200813121045__InsertUITranForSignup $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200813121045__InsertUITranForSignup $$
 
DELIMITER ;