DELIMITER $$
DROP PROCEDURE IF EXISTS V20200817133940__UpdateUITranslationSignup $$
CREATE PROCEDURE V20200817133940__UpdateUITranslationSignup()
BEGIN

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='SIGN_UP_PAGE_SETUP')) THEN
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
VALUES ('TRANSLATIONS','SIGN_UP_PAGE_SETUP','Sign Up Page Setup','Sign Up Page Setup','Teken bladsyopstelling aan', 'Thiết lập trang đăng ký',now(),1);
END IF;

SET SQL_SAFE_UPDATES=0;

IF EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='SIGNUP_ADDITIONAL_SETUP_ADD_SUCCESS')) THEN 
UPDATE `ui_translation` SET `defaultValue`='Details added successfully',
`customerDefineValue`='Details added successfully',
`afriLanguage`='Besonderhede is suksesvol bygevoeg',
`vietLanguage`='Đã thêm chi tiết thành công'
WHERE objectName='TRANSLATIONS' and keyName='SIGNUP_ADDITIONAL_SETUP_ADD_SUCCESS';
END IF; 

IF EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='SIGNUP_ADDITIONAL_SETUP_UPDATE_SUCCESS')) THEN 
UPDATE `ui_translation` SET `defaultValue`='Details updated successfully', 
`customerDefineValue`='Details updated successfully', 
`afriLanguage`='Besonderhede suksesvol opgedateer', 
`vietLanguage`='Đã cập nhật thông tin chi tiết thành công'
WHERE objectName='TRANSLATIONS' and keyName='SIGNUP_ADDITIONAL_SETUP_UPDATE_SUCCESS';
END IF; 

SET SQL_SAFE_UPDATES=1;

END $$
CALL V20200817133940__UpdateUITranslationSignup () $$
DROP PROCEDURE IF EXISTS V20200817133940__UpdateUITranslationSignup $$
DELIMITER ;