DELIMITER $$
DROP PROCEDURE IF EXISTS V20200818162326__Create_term_wise_period_registration $$
CREATE PROCEDURE V20200818162326__Create_term_wise_period_registration()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE()  AND table_name='term_wise_period_registration')) THEN 
CREATE TABLE `term_wise_period_registration` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `registrationTermSetupDetailId` BIGINT(20) NOT NULL,
  `periodStartDate` DATE NOT NULL,
  `periodEndDate` DATE NOT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
	INDEX `fk_registration_term_setup_detail_idx` (`registrationTermSetupDetailId` ASC),
	CONSTRAINT `fk_registration_term_setup_detail`
    FOREIGN KEY (`registrationTermSetupDetailId`)
    REFERENCES `registration_term_setup_detail` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20200818162326__Create_term_wise_period_registration () $$ 
DROP PROCEDURE IF EXISTS V20200818162326__Create_term_wise_period_registration $$ 
DELIMITER ;