DELIMITER $$
DROP PROCEDURE IF EXISTS V20200903125013__Create_CO_PO_View $$
CREATE PROCEDURE V20200903125013__Create_CO_PO_View()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='co_po_mapping_view')) THEN 
CREATE
   OR REPLACE
VIEW `co_po_mapping_view` AS
SELECT
    academyLoc.id AS AcademyLocationId,
    academyLoc.academyCode AS AcademyCode,
    academy.academyName AS AcademyName,
    academyLoc.locationName AS locationName,
    academicT.itemValue AS academicTerm,
batch.batchName AS batchName,
    progBatchPeriodConfig.printName AS Period,
    progBatchPeriodConfig.id AS PeriodId,
    intakeYears.itemValue AS intakeYear,
    programGroup.groupName AS ProgramGroup,
    program.programCode AS ProgramCode,
program.programName AS Program,
    program.programShortName AS programShortName,
    program.programNameToBePrint AS programNameToBePrint,
course.courseCode AS courseCode,
    course.nameToBePrinted AS CourseName,
    course.courseShortName AS courseShortName,
  --  courseVarient.courseVariantDescription AS CourseVariant,
    programOutComestType.code AS ProgramOutcomeType,
    manageCourseOutcomes.courseOutComeCode AS CourseOutcome,
    manageProgramOutcomes.programOutComeCode AS ProgramOutcome,
obeCorrelationLevel.levelName AS CorrelationLevel,
obeCorrelationLevel.levelPercentage AS CorrelationValue
FROM
    map_course_outcomes_program_outcomes AS mapCoPoOutcomes
        INNER JOIN
manage_program_outcomes AS manageProgramOutcomes
           ON manageProgramOutcomes.id =mapCoPoOutcomes.manageProgramOutComeId
       INNER JOIN
     program_out_comes_type AS programOutComestType
ON programOutComestType.id=manageProgramOutcomes.outcomesType
INNER JOIN
manage_course_outcomes AS manageCourseOutcomes
         ON manageCourseOutcomes.id=mapCoPoOutcomes.manageCourseOutComeId
         INNER JOIN
    courses AS course
        ON course.id=manageCourseOutcomes.courseId
       -- INNER JOIN
-- program_batch_course_param AS programBatchCourseParam ON course.id = programBatchCourseParam.courseId
     --   INNER JOIN
  --  course_variants AS courseVarient ON programBatchCourseParam.courseVarientId = courseVarient.id
        INNER JOIN
prog_batch_period_config AS progBatchPeriodConfig
       ON mapCoPoOutcomes.periodId = progBatchPeriodConfig.id
         INNER JOIN
    obe_correlation_level AS obeCorrelationLevel
      ON obeCorrelationLevel.id=mapCoPoOutcomes.obeCorrelationId
          INNER JOIN
    academic_term academicT ON progBatchPeriodConfig.academicTermId = academicT.id
        LEFT OUTER JOIN
    batches batch ON progBatchPeriodConfig.programBatchId = batch.id
        LEFT OUTER JOIN
    intake_year intakeYears ON batch.intakeYearId = intakeYears.id
        LEFT OUTER JOIN
    programs program ON batch.programId = program.id
        LEFT OUTER JOIN
    academy_location academyLoc ON program.academyLocationId = academyLoc.id
        LEFT OUTER JOIN
    academies academy ON academyLoc.academyId = academy.id
        LEFT OUTER JOIN
    program_group programGroup ON program.programGroupId = programGroup.id;
END IF; 

END $$
CALL V20200903125013__Create_CO_PO_View () $$ 
DROP PROCEDURE IF EXISTS V20200903125013__Create_CO_PO_View $$ 
DELIMITER ;