DELIMITER $$
DROP PROCEDURE IF EXISTS V20201008144351__Create_AdmissionConditionTable $$
CREATE PROCEDURE V20201008144351__Create_AdmissionConditionTable()
BEGIN

	IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='admission_condition')) THEN 
		
		CREATE TABLE `admission_condition`( 
		`id` BIGINT(20) NOT NULL AUTO_INCREMENT, 
		`itemCode` varchar(255) NOT NULL,
		`itemValue` varchar(255) NOT NULL,	
		`offerType` VARCHAR(20) NOT NULL,
		`lastUpdate` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
		`lastUpdatedBy` BIGINT(20),
		PRIMARY KEY (`id`), 
		UNIQUE `admission_condition_UNIQUE`(`itemCode`, `offerType`),
		CONSTRAINT `admission_condition_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)) 
		ENGINE=INNODB DEFAULT  CHARSET=utf8; 
	
	END IF; 
	
	IF NOT EXISTS ((SELECT * FROM standard_master where tableName='admission_condition' AND masterName='ADMISSION_CONDITION')) THEN
		
		SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
		INSERT INTO `standard_master` (`id`,`tableName`, `masterName`, `moduleName`, `filterCode`, `whetherChild`, `whetherParent`, `lastUpdatedBy`, `lastUpdate`) 
		VALUES (@standardMasterMaxId+1,'admission_condition', 'ADMISSION_CONDITION', 'Admissions', 'COMMON_MASTER', 0, 0, '1', SYSDATE());

		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items` (`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `emunType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
		VALUES (@ItemsMaxId + 1, 'offerType', 'CONDITION_TYPE', @standardMasterMaxId+1, 'Enum', 'OFFER_TYPE', '1', false, 0, 0,0, '1', SYSDATE());

 		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items` (`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`)
 		VALUES (@ItemsMaxId + 1,'code', 'ITEM_CODE', @standardMasterMaxId+1 , 'varchar', '2', 0, 0, 0, 0, '1', SYSDATE());

 		SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		INSERT INTO `standard_master_items` (`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
		VALUES (@ItemsMaxId + 1,'value', 'ITEM_VALUE', @standardMasterMaxId+1, 'varchar', '3', 0, 0, 0, 0, '1', SYSDATE());
	
	END IF;

END $$
CALL V20201008144351__Create_AdmissionConditionTable () $$ 
DROP PROCEDURE IF EXISTS V20201008144351__Create_AdmissionConditionTable $$ 
DELIMITER ;
