DELIMITER $$
DROP PROCEDURE IF EXISTS V20201013145218__Insert_ExamCancellationReqTranslation $$
CREATE PROCEDURE V20201013145218__Insert_ExamCancellationReqTranslation()
BEGIN

IF NOT EXISTS (( SELECT * FROM ui_translation WHERE objectName="TRANSLATIONS" and keyName="REFERENCE_DOCUMENTS")) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('TRANSLATIONS','REFERENCE_DOCUMENTS','Reference Document','Reference Document','Verwysingsdokument','Tài liệu tham khảo',now(),1);

END IF; 


IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName="TRANSLATIONS" and keyName="APPROVAL/REJECT REMARKS")) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('TRANSLATIONS','APPROVAL/REJECT REMARKS','Approve/Reject Remarks','Approve/Reject Remarks','Opmerkings goedkeur / verwerp','Phê duyệt / Từ chối Nhận xét',now(),1);

END IF; 


IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName="TRANSLATIONS" and keyName="EXAM_CANCELLATION_REQUESTS_LIST")) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('TRANSLATIONS','EXAM_CANCELLATION_REQUESTS_LIST','Exam Cancellation Requests List','Exam Cancellation Requests List','Eksamenkansellasie-versoekelys','Danh sách yêu cầu hủy bài kiểm tra',now(),1);

END IF; 


IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName="TRANSLATIONS" and keyName="STUDENT_REMARKS")) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('TRANSLATIONS','STUDENT_REMARKS','Student Remarks','Student Remarks','Studente-opmerkings','Nhận xét của học sinh',now(),1);

END IF; 


IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName="TRANSLATIONS" and keyName="EXAM_CANCELLATION_REQUESTS")) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('TRANSLATIONS','EXAM_CANCELLATION_REQUESTS','Exam Cancellation Requests','Exam Cancellation Requests','Versoeke om kansellasie van eksamen','Yêu cầu hủy bài kiểm tra',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName="TRANSLATIONS" and keyName="EXAM_CANCELLATION_REQUEST_HAS_BEEN_APPROVED")) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('TRANSLATIONS','EXAM_CANCELLATION_REQUEST_HAS_BEEN_APPROVED','Exam cancellation request has been approved','Exam cancellation request has been approved','Die kansellasieversoek van die eksamen is goedgekeur','Yêu cầu hủy bài kiểm tra đã được chấp thuận',now(),1);
END IF;

IF NOT EXISTS ((SELECT * FROM ui_translation WHERE objectName="TRANSLATIONS" and keyName="EXAM_CANCELLATION_REQUEST_HAS_BEEN_REJECTED")) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('TRANSLATIONS','EXAM_CANCELLATION_REQUEST_HAS_BEEN_REJECTED','Exam cancellation request has been rejected','Exam cancellation request has been rejected','Die kansellasieversoek van die eksamen is van die hand gewys','Yêu cầu hủy bài kiểm tra đã bị từ chối',now(),1);
END IF;

END $$
CALL V20201013145218__Insert_ExamCancellationReqTranslation() $$
DROP PROCEDURE IF EXISTS V20201013145218__Insert_ExamCancellationReqTranslation $$
DELIMITER ;