DELIMITER $$
DROP PROCEDURE IF EXISTS V20201104211352__Create_Election $$
CREATE PROCEDURE V20201104211352__Create_Election()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='election')) THEN 
CREATE TABLE `election` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `electionCode` VARCHAR(255) NOT NULL,
  `electionTypeId` BIGINT(20) NOT NULL,
  `electionName` VARCHAR(255) NOT NULL,
  `electionNameInOtherLanguage` VARCHAR(255) NULL,
  `academicTermId` BIGINT(20) NOT NULL,
  `isAdminCaptureVote` BIT(1) NULL,
  `votingStartDate` DATE NOT NULL,
  `votingStartTime` DATETIME NOT NULL,
  `votingEndDate` DATE NOT NULL,
  `votingEndTime` DATETIME NOT NULL,
  `adminCaptureStartDate` DATE NULL,
  `adminCaptureStartTime` DATETIME NULL,
  `adminCaptureEndDate` DATE NULL,
  `adminCaptureEndTime` DATETIME NULL,
  `isReferendumOne` BIT(1) NULL,
  `referendumOneQuestionInEnglish` TEXT NULL,
  `referendumOneQuestionInOtherLang` TEXT NULL,
  `isReferendumTwo` BIT(1) NULL,
  `referendumTwoQuestionInEnglish` TEXT NULL,
  `referendumTwoQuestionInOtherLang` TEXT NULL,
  `electionDescriptionInEnglish` TEXT NOT NULL,
  `electionDescriptionInOtherLang` TEXT NULL,
  `isActive` BIT(1) NOT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_election_type_id_idx` (`electionTypeId` ASC),
  INDEX `fk_academic_term_id_idx` (`academicTermId` ASC),
  INDEX `fk_users_id_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_election_type_id`
    FOREIGN KEY (`electionTypeId`)
    REFERENCES `election_type_csm` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_academic_term_id`
    FOREIGN KEY (`academicTermId`)
    REFERENCES `academic_term` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_users_id`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);

END IF; 

END $$
CALL V20201104211352__Create_Election () $$ 
DROP PROCEDURE IF EXISTS V20201104211352__Create_Election $$ 
DELIMITER ;