DELIMITER $$
DROP PROCEDURE IF EXISTS V20201106122110__Create_disciplinaryCommiteeDetails $$
CREATE PROCEDURE V20201106122110__Create_disciplinaryCommiteeDetails()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='disciplinary_commitee_details_su')) THEN 
CREATE TABLE `disciplinary_commitee_details_su` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `disciplinaryActionId` bigint DEFAULT NULL,
  `disciplinaryCommitteeId` bigint DEFAULT NULL,
  `determinationDate` datetime DEFAULT NULL,
  `determinationHearingDate` datetime DEFAULT NULL,
  `whetherGuilty` bit(1) DEFAULT NULL,
  `lastUpdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_dis_comm_dis_action_idx` (`disciplinaryActionId`),
  KEY `FK_dis_comm_commitee_idx` (`disciplinaryCommitteeId`),
  KEY `FK_disc_comm_last_idx` (`lastUpdatedBy`),
  CONSTRAINT `FK_dis_comm_commitee` FOREIGN KEY (`disciplinaryCommitteeId`) REFERENCES `committee` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `FK_dis_comm_dis_action` FOREIGN KEY (`disciplinaryActionId`) REFERENCES `disciplinary_actions_su` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `FK_disc_comm_last` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

END IF; 

END $$
CALL V20201106122110__Create_disciplinaryCommiteeDetails () $$ 
DROP PROCEDURE IF EXISTS V20201106122110__Create_disciplinaryCommiteeDetails $$ 
DELIMITER ;