DELIMITER $$
DROP PROCEDURE IF EXISTS V20201106122421__Create_disciplinaryanctionDetailsSU $$
CREATE PROCEDURE V20201106122421__Create_disciplinaryanctionDetailsSU()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='disciplinary_action_details_su')) THEN 
CREATE TABLE `disciplinary_action_details_su` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `disciplinaryActionId` bigint DEFAULT NULL,
  `personId` bigint DEFAULT NULL,
  `lastUpdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_disc_act_su_idx` (`disciplinaryActionId`),
  KEY `fk_disc_act_det_person_idx` (`personId`),
  KEY `fk_disc_act_det_lastupdate_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_disc_act_det_lastupdate` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_disc_act_det_person` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_disc_act_su` FOREIGN KEY (`disciplinaryActionId`) REFERENCES `disciplinary_actions_su` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

END IF; 

END $$
CALL V20201106122421__Create_disciplinaryanctionDetailsSU () $$ 
DROP PROCEDURE IF EXISTS V20201106122421__Create_disciplinaryanctionDetailsSU $$ 
DELIMITER ;