DELIMITER $$
DROP PROCEDURE IF EXISTS V20201109211354__Create_ElectionList $$
CREATE PROCEDURE V20201109211354__Create_ElectionList()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='election_list')) THEN 
CREATE TABLE `election_list` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `electionId` BIGINT(20) NOT NULL,
  `nameInEnglish` VARCHAR(255) NOT NULL,
  `nameInOtherLanguage` VARCHAR(255) DEFAULT NULL,
  `maximumVoteInList` BIGINT(20) NOT NULL,
  `isActive` BIT(1) NOT NULL,
  `remark` TEXT DEFAULT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_el_election_id_idx` (`electionId` ASC),
  INDEX `fk_el_users_id_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_el_election_id`
    FOREIGN KEY (`electionId`)
    REFERENCES `election` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_el_users_id`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);

END IF; 

END $$
CALL V20201109211354__Create_ElectionList () $$ 
DROP PROCEDURE IF EXISTS V20201109211354__Create_ElectionList $$ 
DELIMITER ;