DELIMITER $$
DROP PROCEDURE IF EXISTS V20201111152854__Insert_APPLICANT_PREELIGIBILITY_REPORT $$
CREATE PROCEDURE V20201111152854__Insert_APPLICANT_PREELIGIBILITY_REPORT()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'APPLICANT_PREELIGIBILITY_REPORT')) THEN 
set @applicant = (select id from report_type WHERE typeName = 'Basic Reports');

INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 

VALUES (@applicant, 'APPLICANT_PREELIGIBILITY_REPORT', 'Applicant Pre-Eligibility Report', 'APPLICANT_PREELIGIBILITY_REPORT.png', 'CommonReport_Excel.jasper', 'All', '1', 'Header_Excel_Blank.jasper', 'Header_Excel_Blank.jasper', '1', '1', 'APPLICANT_PREELIGIBILITY_REPORT.jasper', 'AcademiaLogo.png'); 


set @eligibility = (select id from report_template where templateCode ='APPLICANT_PREELIGIBILITY_REPORT');
	
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @eligibility and keyValue='TRANS_REPORT_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@eligibility, 'TRANS_REPORT_NAME', 'Admission Eligibility Status Report -', '1', now());
 END IF;
 
	
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @eligibility and keyValue='TRANS_APPLICATION_ID')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@eligibility, 'TRANS_APPLICATION_ID', 'Application ID', '1', now());
 END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @eligibility and keyValue='TRANS_STD_FIRST_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@eligibility, 'TRANS_STD_FIRST_NAME', 'Student First Name', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @eligibility and keyValue='TRANS_STD_MIDDLE_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@eligibility, 'TRANS_STD_MIDDLE_NAME', 'Student Middle Name', '1', now());
 END IF;

 
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @eligibility and keyValue='TRANS_STD_SURNAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@eligibility, 'TRANS_STD_SURNAME', 'Student Surname', '1', now());
 END IF;

 
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @eligibility and keyValue='TRANS_BRAND')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@eligibility, 'TRANS_BRAND', 'Brand', '1', now());
 END IF;

 
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @eligibility and keyValue='TRANS_CAMPUS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@eligibility, 'TRANS_CAMPUS', 'Campus', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @eligibility and keyValue='TRANS_QUALIFICATION')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@eligibility, 'TRANS_QUALIFICATION', 'Qualification', '1', now());
 END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @eligibility and keyValue='TRANS_QUALIFICATION1')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@eligibility, 'TRANS_QUALIFICATION1', 'Qualification', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @eligibility and keyValue='TRANS_INTAKE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@eligibility, 'TRANS_INTAKE', 'Intake', '1', now());
 END IF;

 
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @eligibility and keyValue='TRANS_INTAKE_YEAR')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@eligibility, 'TRANS_INTAKE_YEAR', 'Intake Year', '1', now());
 END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @eligibility and keyValue='TRANS_APPLICATION_DATE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@eligibility, 'TRANS_APPLICATION_DATE', 'Application Date', '1', now());
 END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @eligibility and keyValue='TRANS_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@eligibility, 'TRANS_NAME', 'Name', '1', now());
 END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @eligibility and keyValue='TRANS_APPLICABILITY')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@eligibility, 'TRANS_APPLICABILITY', 'Applicability', '1', now());
 END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @eligibility and keyValue='TRANS_STATUS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@eligibility, 'TRANS_STATUS', 'Status', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @eligibility and keyValue='TRANS_APS_SCORE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@eligibility, 'TRANS_APS_SCORE', 'APS Score', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @eligibility and keyValue='TRANS_EDU_REMARK')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@eligibility, 'TRANS_EDU_REMARK', 'Education Remarks', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @eligibility and keyValue='TRANS_ELIGIBILITY_STATUS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@eligibility, 'TRANS_ELIGIBILITY_STATUS', 'Eligibility Status', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @eligibility and keyValue='TRANS_APPLICATION_STATUS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@eligibility, 'TRANS_APPLICATION_STATUS', 'Application Status', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @eligibility and keyValue='TRANS_APPROVED_BY')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@eligibility, 'TRANS_APPROVED_BY', 'Approved By', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @eligibility and keyValue='TRANS_APPROVAL_DATE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@eligibility, 'TRANS_APPROVAL_DATE', 'Approval Date', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @eligibility and keyValue='TRANS_APPLICATION_OWNER')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@eligibility, 'TRANS_APPLICATION_OWNER','Application Owner', '1', now());
 END IF;
 
 IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @eligibility and keyValue='TRANS_OFFER_STATUS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@eligibility, 'TRANS_OFFER_STATUS','Offer Status', '1', now());
 END IF;
 
END IF;
END $$
CALL V20201111152854__Insert_APPLICANT_PREELIGIBILITY_REPORT() $$
DROP PROCEDURE IF EXISTS V20201111152854__Insert_APPLICANT_PREELIGIBILITY_REPORT $$
DELIMITER ;
