DELIMITER //
drop procedure if exists sp_tvet_providernqfdetails //
create  procedure sp_tvet_providernqfdetails()
begin

select case when aaw.itemCode='3' then prog.programRegistrationId else '' end Learnership_Id,
case when aaw.itemCode <> '3' then prog.programRegistrationId else '' end Qualification_Id,
'' as Filler01,loc.shortCode as Provider_Code,
541 as Provider_ETQE_Id, '' as Filler02, '' as Filler03,
prog.educationDepartmentRegistrationDate as Provider_Accred_Start_Date,
'' as Provider_Accred_End_Date,
'' as Filler04
,case when alpur.tilldate>=date(now()) then 'Active' else 'Inactive' end as Provider_Status_Id,
case when mda.itemCode=mdb.itemCode and mda.itemCode='3' then '3'
when mda.itemCode=mdb.itemCode and mda.itemCode='4' then '4'
else '7' end Offering_Type_Id,
date_format(now(), '%Y%m%d') as Date_Stamp
from programs prog
left join academic_award aaw on(aaw.id=prog.academicAwardId)
join academy_location al on(al.id=prog.academyLocationId)
join locations loc on(loc.id=al.locationId)
left join academy_location_purpose alpur on(alpur.academyLocationId=al.id and purposeCode='COURSE_EXECUTION')
 join
(select btc.programId,min(btc.id) btc1,max(btc.id) btc2 from programs prog join batches btc on(prog.id=btc.programId)
group by btc.programId) batcha on(prog.id=batcha.programId)
 join batches btca on(batcha.btc1=btca.id and year(now()) between year(btca.startDate) and year(btca.tillDate))
 join mode_of_delivery mda on(btca.modeOfDeliveryId=mda.id)
 join batches btcb on(batcha.btc1=btcb.id and year(now()) between year(btcb.startDate) and year(btcb.tillDate))
 join mode_of_delivery mdb on(btcb.modeOfDeliveryId=mdb.id) group by prog.id;

end//
DELIMITER ;