DELIMITER $$
DROP PROCEDURE IF EXISTS V20201203175459__CreateEnqFormAditionalSetup $$
CREATE PROCEDURE V20201203175459__CreateEnqFormAditionalSetup()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='enquiry_form_additional_Setup')) THEN 
CREATE TABLE enquiry_form_additional_Setup (
    id BIGINT(20) AUTO_INCREMENT primary key,
    captcha_verification TINYINT(1) DEFAULT NULL,
    logo_path VARCHAR(255) DEFAULT NULL,
    document_path VARCHAR(255) DEFAULT NULL,
    background_image_path VARCHAR(255) DEFAULT NULL,
    academy_location_id BIGINT(20) DEFAULT NULL,
    lastUpdate  TIMESTAMP DEFAULT  CURRENT_TIMESTAMP,
    lastUpdatedBy BIGINT(20),
     KEY `fk_enquiry_form_additional_Setup_al_idx` (`academy_location_id`),
     KEY `fk_enquiry_form_additional_Setup_updated_idx` (`lastUpdatedBy`),
    
    CONSTRAINT fk_enquiry_form_additional_Setup_academy_locations
	FOREIGN KEY (academy_location_id) 
	REFERENCES academy_location(id)
	ON DELETE RESTRICT ON UPDATE RESTRICT,
     
    CONSTRAINT fk_enquiry_form_additional_Setup_user
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES users (id)
    ON DELETE RESTRICT ON UPDATE RESTRICT
);
END IF; 

END $$
CALL V20201203175459__CreateEnqFormAditionalSetup() $$ 
DROP PROCEDURE IF EXISTS V20201203175459__CreateEnqFormAditionalSetup $$ 
DELIMITER ;