DELIMITER $$
DROP PROCEDURE IF EXISTS V20201214174404__Create_enquiry_summary_view $$
CREATE PROCEDURE V20201214174404__Create_enquiry_summary_view()
BEGIN

IF EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'enquiry_summary_view')) THEN 
DROP view `enquiry_summary_view`;
END IF; 


IF NOT EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'enquiry_summary_view')) THEN 
CREATE OR REPLACE view enquiry_summary_view as

    SELECT DISTINCT
        `a`.`code` AS `Lead_Id`,
        `a`.`enquiryDate` AS `Lead_Date`,
        `GCon`.`Source_Of_entry` AS `Source_Of_entry`,
        `adk`.`code` AS `Student_ID`,
        `a`.`registeredByType` AS `Enquired_By`,
        `b`.`fatherFirstName` AS `Parent`,
        CONCAT(COALESCE(`b`.`studentFirstName`, ''),
                ' ',
                COALESCE(`b`.`studentMiddleName`, ''),
                ' ',
                COALESCE(`b`.`studentLastName`, '')) AS `Student_Name`,
        `b`.`gender` AS `gender`,
        `b`.`studentDateOfBirth` AS `studentDateOfBirth`,
        `a`.`academyLocationId` AS `academyLocationId`,
        `c`.`displayName` AS `Brand_Campus_Name`,
        `c`.`academyName` AS `Brand_Name`,
        `c`.`locationName` AS `Campus_Name`,
        `e`.`itemValue` AS `Mode_of_Offering`,
        (CASE
            WHEN (`f`.`batchPartTime` = 1) THEN 'Part Time'
            ELSE 'Full Time'
        END) AS `Registration_Type`,
        `d`.`fieldOfInterest` AS `Field_of_Interest`,
        `g`.`programName` AS `GradeName`,
        `g`.`programShortName` AS `Grade`,
        `g`.`programSequence` AS `Grade_Sequence`,
        `h`.`groupName` AS `School_Phase`,
        `i`.`categoryName` AS `Grade_Category`,
        `f`.`printName` AS `Intake`,
        `j`.`itemValue` AS `Intake_Year`,
        `l`.`seatName` AS `Seat_Type`,
        `m`.`campaignName` AS `Brand_Campaign_Name`,
        `m`.`campaignType` AS `campaigntype`,
        `m`.`presentationType` AS `Presentation_type`,
        `m`.`presentationSubType` AS `presentationSubType`,
        `o`.`itemValue` AS `School`,
        `p`.`printName` AS `Lead_Owner_Name`,
        (CASE
            WHEN (`a`.`status` = 'O') THEN 'Open'
            WHEN (`a`.`status` = 'C') THEN 'Closed'
            ELSE NULL
        END) AS `Lead_Status`,
        `q`.`closureDate` AS `Closure_Date`,
        (TO_DAYS(`q`.`closureDate`) - TO_DAYS(`a`.`enquiryDate`)) AS `Closed_No_of_Days`,
        `r`.`type` AS `Lead_Stage`,
        `b`.`id` AS `id`,
        `appl`.`code` AS `Application_ID`,
        `s`.`enquirySource` AS `Lead_point_of_Entry`,
        `t`.`campaignName` AS `Campaign_Name`,
        `u`.`enquiryTypeName` AS `Enquiry_Type`,
        `w`.`status` AS `Closure_Reason`,
        (CASE
            WHEN (`w`.`status` IN ('Already Admitted' , 'Closed Successfully')) THEN 'Yes'
            ELSE 'No'
        END) AS `Closed_Successfully`,
        (SELECT 
                COUNT(`x`.`enquiryId`) AS `No_of_Follow_Up`
            FROM
                `enq_followup` `x`
            WHERE
                (`x`.`enquiryId` = `a`.`id`)) AS `No_of_Follow_Up`,
        `y`.`priority` AS `priority`,
        `a`.`remark` AS `Comment`,
        `ab`.`countryName` AS `Country`,
        `ac`.`countryRegionName` AS `Province`,
        `ad`.`cityName` AS `City`,
        (CASE
            WHEN
                ((`b`.`sibilingUser1` IS NULL)
                    AND (`b`.`sibilingUser2` IS NULL)
                    AND (`b`.`sibilingUser3` IS NULL))
            THEN
                'No'
            ELSE 'Yes'
        END) AS `Sibling_Studying_presently_in_the_organisation`,
        (CASE
            WHEN (`a`.`whetherCompanySponsored` = 1) THEN 'Yes'
            WHEN (`a`.`whetherCompanySponsored` = 0) THEN 'No'
            ELSE NULL
        END) AS `Company_Sponsored`,
        (CASE
            WHEN (`b`.`fatherEmployed` = 1) THEN 'Yes'
            WHEN (`b`.`fatherEmployed` = 0) THEN 'No'
            ELSE NULL
        END) AS `Employee_of_Organization`
    FROM
        (((((((((((((((((((((((((((((((((`enquiry` `a`
        LEFT JOIN `enq_student_details` `b` ON ((`a`.`id` = `b`.`enquiryId`)))
        LEFT JOIN `admission_enq_details` `d` ON ((`b`.`id` = `d`.`enqStudentDetailsId`)))
        LEFT JOIN `academy_location` `c` ON ((`d`.`academyLocationId` = `c`.`id`)))
        LEFT JOIN `mode_of_delivery` `e` ON ((`d`.`modeOfDeliveryId` = `e`.`id`)))
        LEFT JOIN `batches` `f` ON ((`d`.`batchId` = `f`.`id`)))
        LEFT JOIN `programs` `g` ON ((`d`.`programId` = `g`.`id`)))
        LEFT JOIN `program_group` `h` ON ((`g`.`programGroupId` = `h`.`id`)))
        LEFT JOIN `program_category` `i` ON ((`g`.`programCategoryId` = `i`.`id`)))
        LEFT JOIN `intake_year` `j` ON ((`f`.`intakeYearId` = `j`.`id`)))
        LEFT JOIN `prog_batch_seat_config` `k` ON ((`d`.`progBatchSeatConfigId` = `k`.`id`)))
        LEFT JOIN `seat_types` `l` ON ((`k`.`seatTypeId` = `l`.`id`)))
        LEFT JOIN `campaign_new` `m` ON ((`a`.`campaignNewId` = `m`.`id`)))
        LEFT JOIN `campaign_school_mapping` `n` ON ((`n`.`campaignNewId` = `m`.`id`)))
        LEFT JOIN `campaign_school` `o` ON ((`n`.`campaignSchoolId` = `o`.`id`)))
        LEFT JOIN `users` `p` ON ((`a`.`userId` = `p`.`id`)))
        LEFT JOIN (SELECT 
            MAX(`kk`.`closureDate`) AS `closureDate`,
                `kk`.`enquiryId` AS `enquiryId`,
                `kk`.`id` AS `id`
        FROM
            `enq_closure_reason` `kk`
        GROUP BY `kk`.`enquiryId`) `q` ON (((`q`.`enquiryId` = `a`.`id`)
            AND (`a`.`status` = 'C'))))
        LEFT JOIN `enq_intermediate_type` `r` ON ((`a`.`enqIntermediateStageId` = `r`.`id`)))
        LEFT JOIN `enquiry_source` `s` ON ((`a`.`enquirySourceId` = `s`.`id`)))
        LEFT JOIN `campaign` `t` ON ((`a`.`campaignId` = `t`.`id`)))
        LEFT JOIN `enquiry_type` `u` ON ((`a`.`enquiryTypeId` = `u`.`id`)))
        LEFT JOIN `enq_closure_reason` `v` ON ((`v`.`enquiryId` = `a`.`id`)))
        LEFT JOIN `closure_reason` `w` ON ((`v`.`closureReasonId` = `w`.`id`)))
        LEFT JOIN `enq_priority` `y` ON ((`a`.`enqPriorityId` = `y`.`id`)))
        LEFT JOIN `enq_address` `z` ON ((`a`.`id` = `z`.`enquiryId`)))
        LEFT JOIN `address` `aa` ON ((`aa`.`id` = `z`.`addressId`)))
        LEFT JOIN `country` `ab` ON ((`aa`.`countryId` = `ab`.`id`)))
        LEFT JOIN `country_region` `ac` ON ((`aa`.`countryRegionId` = `ac`.`id`)))
        LEFT JOIN `city` `ad` ON ((`aa`.`cityId` = `ad`.`id`)))
        LEFT JOIN `application` `appl` ON ((`appl`.`enquiryStudentDetailId` = `b`.`id`)))
        LEFT JOIN `application_program` `ap` ON ((`ap`.`applicationId` = `appl`.`id`)))
        LEFT JOIN `application_admission_detail` `aad` ON ((`aad`.`applicationProgramId` = `ap`.`id`)))
        LEFT JOIN `admission` `adk` ON ((`adk`.`applicationAdmissionId` = `aad`.`id`)))
        LEFT JOIN (SELECT 
            GROUP_CONCAT(`em`.`itemValue`
                    SEPARATOR ',') AS `Source_Of_entry`,
                `enqu`.`code` AS `code`
        FROM
            ((`enquiry` `enqu`
        JOIN `enquiry_multiple_mode` `emm`)
        JOIN `enquiry_mode` `em`)
        WHERE
            ((`enqu`.`id` = `emm`.`enquiryId`)
                AND (`emm`.`enquiryModeId` = `em`.`id`))
        GROUP BY `enqu`.`code`) `GCon` ON ((`a`.`code` = `GCon`.`code`)));
END IF; 

END $$
CALL V20201214174404__Create_enquiry_summary_view () $$ 
DROP PROCEDURE IF EXISTS V20201214174404__Create_enquiry_summary_view $$ 
DELIMITER ;