DELIMITER $$
DROP PROCEDURE IF EXISTS V20201217120454__Alter_AppAdmConditionTable $$
CREATE PROCEDURE V20201217120454__Alter_AppAdmConditionTable()

BEGIN
	
	IF EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='admission_condition_detail' AND column_name='applicationProgramId')) THEN 
		ALTER TABLE `admission_condition_detail` 
		DROP COLUMN `applicationProgramId`,
		DROP FOREIGN KEY `admission_condition_detail_applicationProgramId_FK`;
	END IF;

	IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='admission_condition_detail' AND column_name='appProgramAdmDetailsId')) THEN 
		ALTER TABLE `admission_condition_detail` 
		ADD COLUMN `appProgramAdmDetailsId` bigint(20) NULL DEFAULT NULL,
		ADD COLUMN `conditionCheck` BIT(1) NULL DEFAULT NULL,
		ADD CONSTRAINT `admission_condition_detail_appProgramAdmDetailsId_FK` FOREIGN KEY (`appProgramAdmDetailsId`) REFERENCES `app_program_adm_details`(`id`);
	END IF;
		
END $$

CALL V20201217120454__Alter_AppAdmConditionTable $$
DROP PROCEDURE IF EXISTS V20201217120454__Alter_AppAdmConditionTable $$
DELIMITER ;


