DELIMITER //
DROP PROCEDURE IF EXISTS sp_tvet_staffwbedetails //
CREATE  PROCEDURE sp_tvet_staffwbedetails()
BEGIN

select distinct
educationDepartmentProgramCode as ProgrammeCode, 
programNameToBePrint as Programme_Description,
pph.id as Programme_Type_Id,
hl.itemCode as NQF_Level_Id, pcesm.itemCode as Subfield_Id,
rt.itemCode as AET_Level_Id, max(DATE_FORMAT(b.startDate, '%Y%m%d')) as Programme_Start_Date,
 DATE_FORMAT(b.tillDate, '%Y%m%d') as Programme_End_Date, al.locationCode as Provider_Code,
 '541' Provider_ETQE_Id, CASE
 WHEN p.status ='O' THEN 1 ELSE 2 END as Programme_Status_Id ,
 b.minProgramCredits as Programme_Credit, DATE_FORMAT(now(), '%Y%m%d') as Date_Stamp
 from 
   batches b left join 
 programs p on (b.programId=p.id) 
 left join academy_location al on al.id=p.academyLocationId
 left join program_group pg  on pg.id=p.programGroupId
 left join program_phase pph on pph.id=p.programPhaseId
 left join program_cesm pcesm on pcesm.id=p.programCESMId
 left join heqf_level hl on hl.id=p.heqfLevelId
 left join registration_type rt on rt.id=p.registrationTypeId
 left join affiliated_university au on au.id=p.affiliatedUniversityId
 where year(now()) between year(b.startDate) and year(b.tillDate) group by b.id;
 
END//
DELIMITER ;