DELIMITER $$
DROP PROCEDURE IF EXISTS V20210108134012__Insert_SponsorStatementOfAC $$
CREATE PROCEDURE V20210108134012__Insert_SponsorStatementOfAC()
BEGIN


IF EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'SPONSOR_STATEMENT_OF_ACCOUNT')) THEN 
set @fbcSponsor = (select max(id) from report_type WHERE typeName = 'Sponsor Statement of Account');


INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@fbcSponsor, 'SPONSOR_STATEMENT_OF_ACCOUNT', 'Falsebay Sponsor Statement of Account', 'SPONSOR_STATEMENT_OF_ACCOUNT.png', 'CommonReport.jasper', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'FALSEBAY_SPONSOR_STATEMENT_OF_ACCOUNT.jasper', 'AcademiaLogo.png');


set @sponsor = (select max(id) from report_template where templateCode ='SPONSOR_STATEMENT_OF_ACCOUNT');

	
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @sponsor and keyValue='TRANS_STATEMENT1')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@sponsor, 'TRANS_STATEMENT1', 'Statement', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @sponsor and keyValue='TRANS_TO1')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@sponsor, 'TRANS_TO1', 'To:', '1', now());
 END IF;
	
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @sponsor and keyValue='TRANS_DATE1')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@sponsor, 'TRANS_DATE1', 'Date:', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @sponsor and keyValue='TRANS_UPTO1')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@sponsor, 'TRANS_UPTO1', 'Transactions Up To: ', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @sponsor and keyValue='TRANS_PAGE1')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@sponsor, 'TRANS_PAGE1', 'Page:', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @sponsor and keyValue='TRANS_QUALIFICATION1')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@sponsor, 'TRANS_QUALIFICATION1', 'Qualification:', '1', now());
 END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @sponsor and keyValue='TRANS_SPONSORNO1')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@sponsor, 'TRANS_SPONSORNO1', 'Sponsor No.:', '1', now());
 END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @sponsor and keyValue='TRANS_NUMOF_STD1')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@sponsor, 'TRANS_NUMOF_STD1', 'No.of Student(s)', '1', now());
 END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @sponsor and keyValue='TRANS_CURRENCY1')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@sponsor, 'TRANS_CURRENCY1', 'Currency:', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @sponsor and keyValue='TRANS_DATE11')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@sponsor, 'TRANS_DATE11', 'Date', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @sponsor and keyValue='TRANS_REFERENCE1')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@sponsor, 'TRANS_REFERENCE1', 'Reference', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @sponsor and keyValue='TRANS_DESCRIPTION1')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@sponsor, 'TRANS_DESCRIPTION1', 'Description', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @sponsor and keyValue='TRANS_DEBIT1')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@sponsor, 'TRANS_DEBIT1', 'Debit', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @sponsor and keyValue='TRANS_CREDIT1')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@sponsor, 'TRANS_CREDIT1', 'Credit', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @sponsor and keyValue='TRANS_GREATER1')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@sponsor, 'TRANS_GREATER1', '>90 Days', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @sponsor and keyValue='TRANS_60DAYS1')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@sponsor, 'TRANS_60DAYS1', '60-90 Days', '1', now());
 END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @sponsor and keyValue='TRANS_30DAYS1')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@sponsor, 'TRANS_30DAYS1', '30-60 Days', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @sponsor and keyValue='TRANS_CURRENT1')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@sponsor, 'TRANS_CURRENT1', 'Current', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @sponsor and keyValue='TRANS_TOTAL1')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@sponsor, 'TRANS_TOTAL1', 'Total', '1', now());
 END IF;


END IF;
END $$
CALL V20210108134012__Insert_SponsorStatementOfAC() $$
DROP PROCEDURE IF EXISTS V20210108134012__Insert_SponsorStatementOfAC $$
DELIMITER ;
