DELIMITER $$
DROP PROCEDURE IF EXISTS V20210115120449__Insert_SUBStudentIdCardReportTemp $$
CREATE PROCEDURE V20210115120449__Insert_SUBStudentIdCardReportTemp()
BEGIN

IF NOT EXISTS ((select * from report_template where templateCode = 'SUB_StudentIDCard')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `templateType`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES ('7', 'SUB_StudentIDCard', 'SUB Student ID Card', 'SUB_StudentIDCard.png', 'CommonReport_IdCard_SUB.jasper', NULL, 'All', '1', 'FooterBlank_IdCard.jasper', 'FooterBlank_IdCard.jasper', '0', '0', 'SUB_StudentIDCard.jasper', 'AcademiaLogo.png');

set @SUB_StudentIDCardTempId = (select max(id) from report_template where templateCode ='SUB_StudentIDCard');

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@SUB_StudentIDCardTempId, 'TRANS_ENROLMENT_NO', 'Enrollment No', '1', NOW()),
(@SUB_StudentIDCardTempId, 'TRANS_SCHOLAR_NO', 'Scholar No', '1', NOW()),
(@SUB_StudentIDCardTempId, 'TRANS_NAME', 'Name', '1', NOW()),
(@SUB_StudentIDCardTempId, 'TRANS_FATHERS_NAME', 'Fathers Name', '1', NOW()),
(@SUB_StudentIDCardTempId, 'TRANS_SCHOOL_COLLEGE', 'School/College', '1', NOW()),
(@SUB_StudentIDCardTempId, 'TRANS_PROGRAM_NAME', 'Program Name', '1', NOW()),
(@SUB_StudentIDCardTempId, 'TRANS_ADMISSION_SESSION', 'Admission Session', '1', NOW()),
(@SUB_StudentIDCardTempId, 'TRANS_DATE_OF_ISSUE', 'Date of Issue', '1', NOW()),
(@SUB_StudentIDCardTempId, 'TRANS_VALID_UPTO', 'Valid Upto', '1', NOW()),
(@SUB_StudentIDCardTempId, 'TRANS_PARENT_CONTACT_NO', 'Parent Contact No', '1', NOW()),
(@SUB_StudentIDCardTempId, 'TRANS_BLOOD_GROUP', 'Blood Group', '1', NOW()),
(@SUB_StudentIDCardTempId, 'TRANS_GENDER', 'Gender', '1', NOW()),
(@SUB_StudentIDCardTempId, 'TRANS_BARCODE', 'Barcode', '1', NOW()),
(@SUB_StudentIDCardTempId, 'TRANS_DATE_OF_BIRTH', 'Date of Birth', '1', NOW()),
(@SUB_StudentIDCardTempId, 'TRANS_ADDRESS', 'Address', '1', NOW()),
(@SUB_StudentIDCardTempId, 'TRANS_RULES_AND_REGULATIONS', 'Rules & Regulations', '1', NOW()),
(@SUB_StudentIDCardTempId, 'TRANS_NO1', '1)', '1', NOW()),
(@SUB_StudentIDCardTempId, 'TRANS_NO2', '2)', '1', NOW()),
(@SUB_StudentIDCardTempId, 'TRANS_NO3', '3)', '1', NOW()),
(@SUB_StudentIDCardTempId, 'TRANS_REGISTRAR', 'Registrar', '1', NOW()),
(@SUB_StudentIDCardTempId, 'TRANS_RULE1', 'Student must carry this card in person & produce it whenever asked by university officials.', '1', NOW()),
(@SUB_StudentIDCardTempId, 'TRANS_RULE2', 'This card is non transferable.', '1', NOW()),
(@SUB_StudentIDCardTempId, 'TRANS_RULE3', 'If card lost/stolen, the student must notify the university officials.', '1', NOW());

END IF; 

END $$
CALL V20210115120449__Insert_SUBStudentIdCardReportTemp() $$
DROP PROCEDURE IF EXISTS V20210115120449__Insert_SUBStudentIdCardReportTemp $$
DELIMITER ;