DELIMITER $$
DROP PROCEDURE IF EXISTS V20210115151840__Insert_WithdrawRejectApproveAdDataGrid $$
CREATE PROCEDURE V20210115151840__Insert_WithdrawRejectApproveAdDataGrid()

BEGIN

	IF NOT EXISTS ((SELECT * FROM data_grid WHERE gridName="Academia.view.admission.applications.applicantProfileBase.AdmissionGrid" AND portalId=1)) THEN 
		INSERT INTO `data_grid`(`gridName`,`portalId`,`jsonObject`,`lastUpdate`,`lastUpdatedBy`) VALUES
		('Academia.view.admission.applications.applicantProfileBase.AdmissionGrid',1,
		'[{"id":null,"columnName":"ADMISSION_ID","dataIndex":"admissionId","columnVisibility":"HIDE","sequence":1,"mandatory":false},
		{"id":null,"columnName":"ACADEMY","dataIndex":"academy.value","columnVisibility":"SHOW","sequence":2,"mandatory":true},
		{"id":null,"columnName":"LOCATION","dataIndex":"location.value","columnVisibility":"SHOW","sequence":3,"mandatory":true},
		{"id":null,"columnName":"PROGRAM","dataIndex":"program.value","columnVisibility":"SHOW","sequence":4,"mandatory":true},
		{"id":null,"columnName":"MODE_OF_DELIVERY","dataIndex":"modeOfDelivery.value","columnVisibility":"HIDE","sequence":5,"mandatory":false},
		{"id":null,"columnName":"REGISTRATION_TYPE","dataIndex":"batchPartTime","columnVisibility":"HIDE","sequence":6,"mandatory":false},
		{"id":null,"columnName":"BATCH","dataIndex":"batch.value","columnVisibility":"SHOW","sequence":7,"mandatory":true},
		{"id":null,"columnName":"SEAT_TYPE","dataIndex":"seatType.value","columnVisibility":"SHOW","sequence":8,"mandatory":false},
		{"id":null,"columnName":"ADMISSION_DATE_AD","dataIndex":"admissionDate","columnVisibility":"HIDE","sequence":9,"mandatory":false}]',now(),1);
	END IF; 

END $$

CALL V20210115151840__Insert_WithdrawRejectApproveAdDataGrid() $$
DROP PROCEDURE IF EXISTS V20210115151840__Insert_WithdrawRejectApproveAdDataGrid $$
DELIMITER ;
