DELIMITER $$
DROP PROCEDURE IF EXISTS V20210201190743__Create_ExportAllApplicationView $$
CREATE PROCEDURE V20210201190743__Create_ExportAllApplicationView()
BEGIN
	
IF EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'application_export_all_view')) THEN 
DROP view `application_export_all_view`;
END IF; 

IF NOT EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'application_export_all_view')) THEN 
CREATE 
VIEW `application_export_all_view` AS
SELECT 
        `t3`.`code` AS `APPLICATION_ID`,
        `t3`.`currentStatus` AS `APPLICATION_CURRENT_STATUS`,
        `t2`.`printName` AS `FULL_NAME`,
        `t2`.`firstName` AS `FIRST_NAME`,
        `t2`.`middleName` AS `MIDDLE_NAME`,
        `t2`.`lastName` AS `LAST_NAME`,
        `t20`.`academyName` AS `ACADEMY`,
        `t19`.`locationName` AS `LOCATION`,
        `t5`.`programName` AS `PROGRAM_NAME`,
        `t15`.`batchName` AS `BATCH`,
        `t68`.`value` AS `PRE_ELIGIBILITY`,
        `t15`.`id` AS `BATCH_ID`,
        `t8`.`seatName` AS `SEAT_TYPE`,
        `t8`.`id` AS `SEAT_TYPE_ID`,
        `t54`.`printName` AS `APPLICATION_OWNER`,
        `t52`.`whetherHostelApplicable` AS `HOSTEL_REQUIRED`,
        `t59`.`defaultValue` AS `APPLICATION_VIEW_STATUS`,
        `t51`.`value` AS `PROGRAM_WITHDRAWN_REASON`,
        `t57`.`defaultValue` AS `OFFER_STATUS`,
        `t12`.`stageName` AS `CURRENT_STAGE`,
        IF((`t61`.`defaultValue` = 'SELECTED'),
            'Passed',
            IF((`t61`.`defaultValue` = 'WAITING'),
                'No Place Available',
                `t61`.`defaultValue`)) AS `STAGE_VIEW_STATUS`,
        `t58`.`defaultValue` AS `ADMISSION_VIEW_STATUS`,
        `t3`.`applicationCreationSource` AS `APPLICATION_CREATION_SOURCE`,
        `t50`.`printName` AS `APPROVED_PERSON`,
        `t3`.`applicationApprovedOn` AS `APPLICATION_APPROVED_DATE`,
        `t3`.`applicationCreatedOn` AS `APPLICATION_DATE`,
        `t43`.`firstName` AS `FATHERS_FULL_NAME`,
        `t43`.`firstName` AS `FATHERS_FIRST_NAME`,
        `t43`.`middleName` AS `FATHERS_MIDDLE_NAME`,
        `t43`.`lastName` AS `FATHERS_LAST_NAME`,
        `t48`.`firstName` AS `MOTHERS_FULL_NAME`,
        `t48`.`firstName` AS `MOTHERS_FIRST_NAME`,
        `t48`.`middleName` AS `MOTHERS_MIDDLE_NAME`,
        `t48`.`lastName` AS `MOTHERS_LAST_NAME`,
        `t27`.`beneficiaryName` AS `BENEFICIARY_NAME`,
        `t27`.`accountNumber` AS `ACCOUNT_NUMBER`,
        `t27`.`accountType` AS `ACCOUNT_TYPE`,
        `t27`.`bankName` AS `BANK_NAME`,
        `t27`.`branchName` AS `BRANCH_NAME`,
        `t27`.`IFSCode` AS `IFSCODE`,
        `t2`.`birthDate` AS `DATE_OF_BIRTH`,
        `t62`.`itemValue` AS `GENDER`,
        `t2`.`category` AS `CATEGORY`,
        `t2`.`emailId` AS `EMAIL`,
        `t2`.`mobileCountryCode` AS `MOBILE_COUNTRY_CODE`,
        `t2`.`mobileNumber` AS `MOBILE_NUMBER`,
        `t2`.`phoneCountryCode` AS `PHONE_COUNTRY_CODE`,
        `t2`.`phoneAreaCode` AS `PHONE_AREA_CODE`,
        `t2`.`phoneNo` AS `PHONE_NO`,
        `t2`.`bloodGroup` AS `BLOOD_GROUP`,
        `t45`.`itemValue` AS `RELIGION`,
        `t46`.`itemValue` AS `CASTE_CATEGORY`,
        `t2`.`comments` AS `APPLICATION_GRID_COMMENTS`,
        (CASE
            WHEN (`t10`.`whetherFeePlanApplicable` = 0) THEN 'false'
            WHEN (`t10`.`whetherFeePlanApplicable` = 1) THEN 'true'
            ELSE NULL
        END) AS `WHETHER_FEE_PLAN_APPLICABLE`,
        `t44`.`billStatus` AS `BILL_STATUS`,
        `t59`.`defaultValue` AS `APPLICATION_STATUS`,
        `t57`.`defaultValue` AS `PROGRAM_STATUS`,
        `t61`.`defaultValue` AS `STAGE_STATUS`,
        `t60`.`defaultValue` AS `ADMISSION_STATUS`,
        `t53`.`countryName` AS `COUNTRY`,
        `t49`.`itemValue` AS `NATIONALITY`,
        `t2`.`nationalID` AS `NATIONAL_ID`,
        `t2`.`printName` AS `APPLICATION_PERSON_PRINTNAME`,
        `t2`.`id` AS `APPLICATION_PERSON_ID`,
        `t14`.`id` AS `ADMISSION_PRIMERY_ID`,
        `t3`.`id` AS `APPLICATION_PRIMERY_ID`,
        `t1`.`id` AS `APPLICATION_PROGRAM_ID`,
        `t1`.`programId` AS `PROGRAM_ID`,
        `t7`.`id` AS `PROG_BATCH_SEAT_CONFIG_ID`,
        `t1`.`academyLocationId` AS `ACADEMY_LOCATION_ID`,
        `t3`.`id` AS `ID`,
        `t26`.`externalUserId` AS `EXTERNAL_USER_ID`,
        `t7`.`id` AS `IS_OFFER_LETTER_APPLICABLE`,
        `t56`.`printName` AS `FOLLOW_UP_USER`,
        `t54`.`id` AS `APPLICATION_OWNER_ID`,
        `t63`.`id` AS `INTAKE_YEAR_ID`,
        `t64`.`id` AS `SELECTION_PROCESS`,
        `t66`.`code` AS `ENQUIRY_NO`,
        `t67`.`id` AS `PROGRAM_GROUP`,
        `t11`.`id` AS `CURRENT_STAGE_ID`,
        `t53`.`id` AS `COUNTRY_ID`,
        `t2`.`alternateMobileNo` AS `ALTERNATE_EMAIL_ID`,
        `t68`.`id` AS `PRE_ELIGIBILITY_ID`,
        `t69`.`priority` AS `ENQUIRY_PRIORITY`,
		`t3`.`applicationIdentifier` AS `APPLICATION_IDENTIFIER`,
        (CASE
            WHEN (`t15`.`batchPartTime` = 0) THEN 'Full Time'
            WHEN (`t15`.`batchPartTime` = 1) THEN 'Part Time'
            ELSE NULL
       END) AS `REGISTRATION_TYPE`,
       `modl`.`itemValue` AS `MODE_OF_DELIVERY`,
		`t66`.`code` AS `ENQUIRY_ID`,
        `t55`.`followUpDate` AS `FOLLOWUP_PLANNED_DATE`,
		CAST(`t1`.`offerLetterAcceptanceDate` AS DATE) AS `OFFER_LETTER_ACCEPTANCE_DATE`,
		`modl`.`id` AS `MODE_OF_DELIVERY_ID`,
		`t3`.`applicationAssignDate` AS `APPLICATION_REASSIGN_DATE`,
		(select GROUP_CONCAT(`enquiry_mode`.`itemValue`) from `enquiry_mode` inner join `application_enquiry_multiple_mode` on `application_enquiry_multiple_mode`.`enquiryModeId`=`enquiry_mode`.`id` where `application_enquiry_multiple_mode`.`applicationId`=`t3`.`id`) AS `MODE_OF_ENQUIRY`,
		(CASE
            WHEN (`t70`.`offerType` = 'FIRM') THEN 'Firm Offer'
            WHEN (`t70`.`offerType` = 'PROVISIONAL') THEN 'Provisional Offer'
            ELSE NULL
       	END) AS `OFFER_TYPE`,
       	t43.nationalID AS NATIONAL_ID_FATHER,
		t48.nationalID AS NATIONAL_ID_MOTHER
    FROM	
        (((((((((((((((((((((((((((((((((((((((((((((`application` `t3`
        LEFT JOIN `users` `t54` ON ((`t54`.`id` = `t3`.`applicationOwner`)))
        JOIN `applicant_person` `t2` ON ((`t2`.`id` = `t3`.`applicantPersonId`)))
        LEFT JOIN `application_program` `t1` ON ((`t3`.`id` = `t1`.`applicationId`)))
        LEFT JOIN `users` `t50` ON ((`t50`.`id` = `t3`.`applicationApprovedBy`)))
        LEFT JOIN `external_user_association` `t26` ON (((`t3`.`id` = `t26`.`applicationId`)
            AND (`t26`.`referencyEntityType` = 'APPLICATION'))))
        LEFT JOIN `applicant_person_relationships` `t47` ON (((`t47`.`applicantPersonId` = `t2`.`id`)
            AND (`t47`.`relationship` = 'MOTHER')
            AND (`t47`.`whetherDeleted` = 0))))
        LEFT JOIN `applicant_person_relationships` `t42` ON (((`t42`.`applicantPersonId` = `t2`.`id`)
            AND (`t42`.`relationship` = 'FATHER')
            AND (`t42`.`whetherDeleted` = 0))))
        LEFT JOIN `country` `t53` ON ((`t2`.`countryId` = `t53`.`id`)))
        LEFT JOIN `religions` `t45` ON ((`t2`.`religionId` = `t45`.`id`)))
        LEFT JOIN `applicant_bank_details` `t27` ON ((`t2`.`bankDetailId` = `t27`.`id`)))
        LEFT JOIN `nationalities` `t49` ON ((`t2`.`nationalityId` = `t49`.`id`)))
        LEFT JOIN `applicant_hostel_requirement` `t52` ON (((`t52`.`applicantPersonId` = `t2`.`id`)
            AND (`t52`.`whetherDeleted` = 0))))
        LEFT JOIN `caste_categories` `t46` ON ((`t2`.`casteCategoryId` = `t46`.`id`)))
        LEFT JOIN `academy_location` `t4` ON ((`t4`.`id` = `t1`.`academyLocationId`)))
        LEFT JOIN `programs` `t5` ON ((`t5`.`id` = `t1`.`programId`)))
        LEFT JOIN `prog_batch_seat_config` `t7` ON ((`t7`.`id` = `t1`.`progBatchSeatConfigId`)))
        LEFT JOIN `application_prog_withdraw_reasons` `t51` ON ((`t51`.`id` = `t1`.`withdrawl_reason_id`)))
        LEFT JOIN `application_admission_detail` `t18` ON ((`t18`.`applicationProgramId` = `t1`.`id`)))
        LEFT JOIN `program_slctn_process_stages` `t10` ON ((`t10`.`id` = `t1`.`currentStageId`)))
        LEFT JOIN `applicant_person` `t48` ON (((`t48`.`id` = `t47`.`relatedApplicantPersonId`)
            AND (`t47`.`relationship` = 'MOTHER')
            AND (`t47`.`whetherDeleted` = 0))))
        LEFT JOIN `applicant_person` `t43` ON (((`t43`.`id` = `t42`.`relatedApplicantPersonId`)
            AND (`t42`.`relationship` = 'FATHER')
            AND (`t42`.`whetherDeleted` = 0))))
        LEFT JOIN `locations` `t19` ON ((`t19`.`id` = `t4`.`locationId`)))
        LEFT JOIN `academies` `t20` ON ((`t20`.`id` = `t4`.`academyId`)))
        LEFT JOIN `batches` `t15` ON ((`t15`.`id` = `t7`.`programBatchId`)))
        LEFT JOIN `seat_types` `t8` ON ((`t8`.`id` = `t7`.`seatTypeId`)))
        LEFT JOIN `admission` `t14` ON ((`t14`.`applicationAdmissionId` = `t18`.`id`)))
        LEFT JOIN `application_prog_stage` `t9` ON (((`t9`.`applicationProgramId` = `t1`.`id`)
            AND (`t9`.`programSelectionProcessStageId` = `t10`.`id`))))
        LEFT JOIN `slctn_process_stage` `t11` ON ((`t11`.`id` = `t10`.`selectionProcessStageId`)))
        LEFT JOIN `bill_header` `t44` ON ((`t44`.`applicationProgramStageId` = `t9`.`id`)))
        LEFT JOIN `selection_stage` `t12` ON ((`t12`.`id` = `t11`.`stageId`)))
        LEFT JOIN `ui_translation` `t57` ON (((`t57`.`keyName` = `t1`.`currentStatus`)
            AND (`t57`.`objectName` = 'Admission'))))
        LEFT JOIN `ui_translation` `t58` ON (((`t58`.`keyName` = `t18`.`status`)
            AND (`t58`.`objectName` = 'Admission'))))
        LEFT JOIN `ui_translation` `t59` ON (((`t59`.`keyName` = `t3`.`currentStatus`)
            AND (`t59`.`objectName` = 'Admission'))))
        LEFT JOIN `ui_translation` `t60` ON (((`t60`.`keyName` = `t14`.`status`)
            AND (`t60`.`objectName` = 'Admission'))))
        LEFT JOIN `ui_translation` `t61` ON (((`t61`.`keyName` = `t9`.`currentStatus`)
            AND (`t61`.`objectName` = 'Admission'))))
        LEFT JOIN `application_followup` `t55` ON (((`t55`.`applicationId` = `t3`.`id`)
            AND (`t55`.`isLatestFollowUp` = TRUE))))
        LEFT JOIN `users` `t56` ON ((`t56`.`id` = `t55`.`userId`)))
        LEFT JOIN `gender` `t62` ON ((`t62`.`id` = `t2`.`genderId`)))
        LEFT JOIN `intake_year` `t63` ON ((`t63`.`id` = `t15`.`intakeYearId`)))
        LEFT JOIN `slctn_process` `t64` ON ((`t64`.`id` = `t11`.`selectionProcessId`)))
        LEFT JOIN `enq_student_details` `t65` ON ((`t65`.`id` = `t3`.`enquiryStudentDetailId`)))
        LEFT JOIN `enquiry` `t66` ON ((`t66`.`id` = `t65`.`enquiryId`)))
        LEFT JOIN `program_group` `t67` ON ((`t67`.`id` = `t5`.`programGroupId`)))
        LEFT JOIN `drop_down` `t68` ON ((`t68`.`id` = `t1`.`preEligibility`)))
        LEFT JOIN `enq_priority` `t69` ON ((`t69`.`id` = `t55`.`enqPriorityId`))
        LEFT JOIN `mode_of_delivery` `modl` ON ((`modl`.`id` = `t15`.`modeOfDeliveryId`))
        LEFT JOIN `app_program_adm_details` `t70` ON ((`t70`.`applicationProgramId` = `t1`.`id`)
         	AND (`t70`.`isLatest` = TRUE)))
    WHERE
        ((`t3`.`code` IS NOT NULL))
    ORDER BY `t3`.`applicationCreatedOn` DESC;
END IF; 

END $$
CALL V20210201190743__Create_ExportAllApplicationView () $$ 
DROP PROCEDURE IF EXISTS V20210201190743__Create_ExportAllApplicationView $$ 
DELIMITER ;