DELIMITER $$
DROP PROCEDURE IF EXISTS V20210210141717__Insert_reportTemplate $$
CREATE PROCEDURE V20210210141717__Insert_reportTemplate()
BEGIN

IF NOT EXISTS (select * from report_template where `templateCode`='EXAM_TIME_TABLE_REPORT') THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES ('10', 'EXAM_TIME_TABLE_REPORT', 'Exam Timetable Report', 'EXAM_TIME_TABLE_REPORT.png', 'CommonReport_Excel_withoutHeader.jasper', 'All', '1', 'Header_Excel_Blank.jasper', 'Header_Excel_Blank.jasper', '1', '1', 'EXAM_TIME_TABLE_REPORT.jasper', 'AcademiaLogo.png');
END IF; 

set @reportTempId = (select max(id) from report_template where templateCode='EXAM_TIME_TABLE_REPORT' and templateName='Exam Timetable Report');

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='TRANS_TIME_TABLE_FOR') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'TRANS_TIME_TABLE_FOR', 'TIMETABLE FOR', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='TRANS_SRNO') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'TRANS_SRNO', 'S.NO.', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='TRANS_PROGRAM') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'TRANS_PROGRAM', 'PROGRAM', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='TRANS_BATCH') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'TRANS_BATCH', 'BATCH', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='TRANS_SEMESTER') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'TRANS_SEMESTER', 'SEMESTER', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='TRANS_COURSE_CODE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'TRANS_COURSE_CODE', 'COURSE CODE', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='TRANS_COURSE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'TRANS_COURSE', 'COURSE', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='TRANS_DATE_WITHDAY') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'TRANS_DATE_WITHDAY', 'DATE WITH DAY', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='TRANS_TIMING') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'TRANS_TIMING', 'TIMING', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='TRANS_ASSESSMENT_SCHEME') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'TRANS_ASSESSMENT_SCHEME', 'ASSESSMENT SCHEME', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='TRANS_ASSESSMENT_EVENT') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'TRANS_ASSESSMENT_EVENT', 'ASSESSMENT EVENT', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='TRANS_MARKS_GRADE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'TRANS_MARKS_GRADE', 'Max. MARKS/GRADE', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='TRANS_DATE') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'TRANS_DATE', 'Date:', NOW());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @reportTempId AND keyValue='TRANS_CONTROLLER') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
	VALUES (@reportTempId, 'TRANS_CONTROLLER', 'CONTROLLER OF EXAMINATIONS', NOW());
END IF;

END $$
CALL V20210210141717__Insert_reportTemplate() $$
DROP PROCEDURE IF EXISTS V20210210141717__Insert_reportTemplate $$
DELIMITER  ;