SET SQL_SAFE_UPDATES = 0;
DELIMITER $$
DROP PROCEDURE IF EXISTS V20210316124342__Alter_EconomicInfo_ModifyColumns $$
CREATE PROCEDURE V20210316124342__Alter_EconomicInfo_ModifyColumns()
BEGIN 

IF EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='economic_information' AND column_name='parent_qualification1')) THEN 
UPDATE `economic_information` SET `parent_qualification1` = NULL where `id` > 0;
ALTER TABLE `economic_information` MODIFY COLUMN `parent_qualification1` BIGINT(20) NULL DEFAULT NULL;

ALTER TABLE `economic_information` 
ADD INDEX `fk_parent_qualification1_idx` (`parent_qualification1` ASC);
ALTER TABLE `economic_information` 
ADD CONSTRAINT `fk_parent_qualification1`
  FOREIGN KEY (`parent_qualification1`)
  REFERENCES `drop_down` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

END IF;

IF EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='economic_information' AND column_name='parent_qualification2')) THEN 
UPDATE `economic_information` SET `parent_qualification2` = NULL where `id` > 0;
ALTER TABLE `economic_information` MODIFY COLUMN `parent_qualification2` BIGINT(20) NULL DEFAULT NULL;
ALTER TABLE `economic_information` 
ADD INDEX `fk_parent_qualification2_idx` (`parent_qualification2` ASC);
ALTER TABLE `economic_information` 
ADD CONSTRAINT `fk_parent_qualification2`
  FOREIGN KEY (`parent_qualification2`)
  REFERENCES `drop_down` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

END IF;

IF EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='economic_information' AND column_name='school_fee_per_year')) THEN 
UPDATE `economic_information` SET `school_fee_per_year` = NULL where `id` > 0;
ALTER TABLE `economic_information` MODIFY COLUMN `school_fee_per_year` BIGINT(20) NULL DEFAULT NULL;
ALTER TABLE `economic_information` 
ADD INDEX `fk_school_fee_per_year_idx` (`school_fee_per_year` ASC);
ALTER TABLE `economic_information` 
ADD CONSTRAINT `fk_school_fee_per_year`
  FOREIGN KEY (`school_fee_per_year`)
  REFERENCES `drop_down` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

END IF;

IF EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='economic_information' AND column_name='is_scholarship')) THEN 
UPDATE `economic_information` SET `is_scholarship` = NULL where `id` > 0;
ALTER TABLE `economic_information` MODIFY COLUMN `is_scholarship` BIGINT(20) NULL DEFAULT NULL;
ALTER TABLE `economic_information` 
ADD INDEX `fk_is_scholarship_idx` (`is_scholarship` ASC);
ALTER TABLE `economic_information` 
ADD CONSTRAINT `fk_is_scholarship`
  FOREIGN KEY (`is_scholarship`)
  REFERENCES `drop_down` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

END IF;

IF EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='economic_information' AND column_name='pay_study')) THEN 
UPDATE `economic_information` SET `pay_study` = NULL where `id` > 0;
ALTER TABLE `economic_information` MODIFY COLUMN `pay_study` BIGINT(20) NULL DEFAULT NULL;
ALTER TABLE `economic_information` 
ADD INDEX `fk_pay_study_idx` (`pay_study` ASC);
ALTER TABLE `economic_information` 
ADD CONSTRAINT `fk_pay_study`
  FOREIGN KEY (`pay_study`)
  REFERENCES `drop_down` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

END IF;

IF EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='economic_information' AND column_name='parent_annual_income')) THEN 
UPDATE `economic_information` SET `parent_annual_income` = NULL where `id` > 0;
ALTER TABLE `economic_information` MODIFY COLUMN `parent_annual_income` BIGINT(20) NULL DEFAULT NULL;
ALTER TABLE `economic_information` 
ADD INDEX `fk_parent_annual_income_idx` (`parent_annual_income` ASC);
ALTER TABLE `economic_information` 
ADD CONSTRAINT `fk_parent_annual_income`
  FOREIGN KEY (`parent_annual_income`)
  REFERENCES `drop_down` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;

END IF;

END $$
CALL V20210316124342__Alter_EconomicInfo_ModifyColumns() $$
DROP PROCEDURE IF EXISTS V20210316124342__Alter_EconomicInfo_ModifyColumns $$
DELIMITER ;
SET SQL_SAFE_UPDATES = 1;