DELIMITER //
DROP PROCEDURE IF EXISTS sp_tvet_staffsubjectdetails //
DELIMITER //
CREATE  PROCEDURE sp_tvet_staffsubjectdetails(in p_alid varchar(1000))
BEGIN


select distinct usr.code as Staff_Number,
'' as Unit_Standard_Id,
course.courseCode as Subject_Code,
case when workex.Year_Teaching_Experience is null then 2 else workex.Year_Teaching_Experience end as Year_Teaching_Experience,
case when pertraining.Years_Formal_Training is null then 1 else pertraining.Years_Formal_Training end as Years_Formal_Training,
loc.shortCode as Provider_Code ,
541 as Provider_ETQE_Id,
DATE_FORMAT(NOW(), '%Y%m%d') AS Date_Stamp
from prog_batch_course_faculty progbcf
join program_batch_course_param progbcp on (progbcf.progBatchCourseParamId=progbcp.id)
join batches b on (progbcp.programBatchId=b.id and b.intakeYearId=1)
LEFT JOIN programs p ON b.programId = p.id
LEFT JOIN academy_location al ON al.id = p.academyLocationId
join locations loc on(loc.id=al.locationId)
-- join course_variants cv on (progbcp.courseVarientId=cv.id)
join courses course on (progbcp.courseId=course.id)
join staffs staf on (progbcf.facultyId=staf.userId)
join persons per on (per.id=staf.personid)
left join (select per.id,
ROUND(sum(TIMESTAMPDIFF(month, joiningDate, exitDate))/12) as Year_Teaching_Experience
from persons per join work_experience we on(per.id=we.personid) group by per.id) workex
on(per.id=workex.id)
left join (select per.id,
ROUND(sum(TIMESTAMPDIFF(month, fromDate, toDate))/12) as Years_Formal_Training
from persons per join person_training_details we on(per.id=we.personid)
join training_type trt on (trt.id=we.trainingTypeId and trt.itemValue='Subject Training')
group by per.id) pertraining
on(pertraining.id=per.id)
join users usr on(usr.id=staf.userId)
where al.locationCode <> 'FBC' 
and usr.code not in ('serotracker','SYSADMIN',
'PUBLIC_PORTAL_USER','APPLICANT_PORTAL_USER','ENQUIRY_PORTAL_USER','SSO_USER','MISAdmin') and usr.status=1 and FIND_IN_SET( al.id,p_alid);

END//
DELIMITER ;
DELIMITER ;