DELIMITER $$
DROP PROCEDURE IF EXISTS V20210602121410__Create_attendanceRange $$
CREATE PROCEDURE V20210602121410__Create_attendanceRange()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='attendance_range' )) THEN 
CREATE TABLE `attendance_range` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `attendanceRuleId` BIGINT NOT NULL,
  `marks`  DOUBLE,
  `rangeFrom`  DOUBLE,
   `rangeTo`  DOUBLE,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `attendanceRange_lastUpdatedby` (`lastUpdatedBy` ASC) ,
  INDEX `attendanceRange_attendanceRuleId` (`attendanceRuleId` ASC) ,
  CONSTRAINT `attendanceRange_df_lastUpdatedBy`
	FOREIGN KEY (`lastUpdatedBy`)
	REFERENCES `users` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION,
  CONSTRAINT `attendanceRange_df_attendanceRuleId`
	FOREIGN KEY (`attendanceRuleId`)
	REFERENCES `attendance_rule` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20210602121410__Create_attendanceRange () $$ 
DROP PROCEDURE IF EXISTS V20210602121410__Create_attendanceRange $$ 
DELIMITER ;