DELIMITER $$
DROP PROCEDURE IF EXISTS V20210602122930__Create_attendanceRuleBMapping $$
CREATE PROCEDURE V20210602122930__Create_attendanceRuleBMapping()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='attendance_rule_batch_mapping')) THEN 
CREATE TABLE `attendance_rule_batch_mapping` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `attendanceRuleId` BIGINT NOT NULL,
  `batchId` BIGINT NOT NULL,
  `academyLocationId` BIGINT NOT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `attendanceRuleBatchMapping_lastUpdatedby` (`lastUpdatedBy` ASC) ,
  INDEX `attendanceRuleBatchMapping_attendanceRuleId` (`attendanceRuleId` ASC) ,
  INDEX `attendance_rule_bm_batchId_idx` (`batchId` ASC) ,
  INDEX `attendance_rule_bm__academyLocationId_idx` (`academyLocationId` ASC) ,
  CONSTRAINT `attendance_rule_bm_lastUpdatedBy`
	FOREIGN KEY (`lastUpdatedBy`)
	REFERENCES `users` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION,
  CONSTRAINT `attendance_rule_bm_attendanceRuleId`
	FOREIGN KEY (`attendanceRuleId`)
	REFERENCES `attendance_rule` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION,
  CONSTRAINT `attendance_rule_bm_batchId`
	FOREIGN KEY (`batchId`)
	REFERENCES `batches` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION,
  CONSTRAINT `attendance_rule_bm_academyLocationId`
	FOREIGN KEY (`academyLocationId`)
	REFERENCES `academy_location` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20210602122930__Create_attendanceRuleBMapping () $$ 
DROP PROCEDURE IF EXISTS V20210602122930__Create_attendanceRuleBMapping $$ 
DELIMITER ;