DELIMITER $$
DROP PROCEDURE IF EXISTS V20210604110435__Insert_AltMobileNoInBulkAdmissionLoader $$
CREATE PROCEDURE V20210604110435__Insert_AltMobileNoInBulkAdmissionLoader()
BEGIN

IF EXISTS ((SELECT * FROM import_utility_master where code = 'bulkadmission')) THEN 
SET @masterId=(SELECT MAX(id) FROM import_utility_master where code = 'bulkadmission');
	
IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'ALTERNATE_CELL_COUNTRY_CODE_HEADER' AND isSchool=0 AND importUtilityMasterId = @masterId)) THEN 
INSERT INTO loader_header(lastUpdate,lastUpdatedBy,headerCode, defaultHeaderLabel, headerLabel,isSchool,isNonEditable,isMandatory,importUtilityMasterId)
VALUES( sysdate()  , 1 ,  'ALTERNATE_CELL_COUNTRY_CODE_HEADER' ,'Alternate Cell Country Code' , 'Alternate Cell Country Code' , 0 , 0 , 0, @masterId) ;
END IF; 


IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'ALTERNATE_CELL_NO_HEADER' AND isSchool=0 AND importUtilityMasterId = @masterId)) THEN 
INSERT INTO loader_header(lastUpdate,lastUpdatedBy,headerCode, defaultHeaderLabel, headerLabel,isSchool,isNonEditable,isMandatory,importUtilityMasterId)
VALUES( sysdate()  , 1 ,  'ALTERNATE_CELL_NO_HEADER' ,'Alternate Cell No.' , 'Alternate Cell No.' , 0 , 0 , 0, @masterId) ;
END IF; 


IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'ALTERNATE_CELL_COUNTRY_CODE_HEADER' AND isSchool=1 AND importUtilityMasterId = @masterId)) THEN 
INSERT INTO loader_header(lastUpdate,lastUpdatedBy,headerCode, defaultHeaderLabel, headerLabel,isSchool,isNonEditable,isMandatory,importUtilityMasterId)
VALUES( sysdate()  , 1 ,  'ALTERNATE_CELL_COUNTRY_CODE_HEADER' ,'Alternate Cell Country Code' , 'Alternate Cell Country Code' , 1 , 0 , 0, @masterId) ;
END IF; 


IF NOT EXISTS ((SELECT * FROM loader_header WHERE headerCode = 'ALTERNATE_CELL_NO_HEADER' AND isSchool=1 AND importUtilityMasterId = @masterId)) THEN 
INSERT INTO loader_header(lastUpdate,lastUpdatedBy,headerCode, defaultHeaderLabel, headerLabel,isSchool,isNonEditable,isMandatory,importUtilityMasterId)
VALUES( sysdate()  , 1 ,  'ALTERNATE_CELL_NO_HEADER' , 'Alternate Cell No.' , 'Alternate Cell No.' , 1 , 0 , 0, @masterId) ;
END IF; 

END IF; 

END $$
CALL V20210604110435__Insert_AltMobileNoInBulkAdmissionLoader() $$
DROP PROCEDURE IF EXISTS V20210604110435__Insert_AltMobileNoInBulkAdmissionLoader $$
DELIMITER ;