DELIMITER $$
DROP PROCEDURE IF EXISTS V20210604114725__Create_nsfaspersoncheckstatus $$
CREATE PROCEDURE V20210604114725__Create_nsfaspersoncheckstatus()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='nsfas_person_status_check')) THEN 
CREATE TABLE `nsfas_person_status_check` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `nationalId` varchar(100) NOT NULL,
  `idType` varchar(150) DEFAULT NULL,
  `processCycle` varchar(30) DEFAULT NULL,
  `applicantPersonId` bigint DEFAULT NULL,
  `studentPersonId` bigint DEFAULT NULL,
  `lastUpdatedBy` bigint NOT NULL,
  `lastUpdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_nsfaspsc_id_idx` (`lastUpdatedBy`),
  KEY `fk_nsfasapplicantperson_id_idx` (`applicantPersonId`),
  KEY `fk_nsfasstudentperson_id_idx` (`studentPersonId`),
  CONSTRAINT `fk_nsfasapplicantperson_id` FOREIGN KEY (`applicantPersonId`) REFERENCES `applicant_person` (`id`),
  CONSTRAINT `fk_nsfaspsc_id` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `fk_nsfasstudentperson_id` FOREIGN KEY (`studentPersonId`) REFERENCES `persons` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


END IF; 

END $$
CALL V20210604114725__Create_nsfaspersoncheckstatus () $$ 
DROP PROCEDURE IF EXISTS V20210604114725__Create_nsfaspersoncheckstatus $$ 
DELIMITER ;