DELIMITER $$
DROP PROCEDURE IF EXISTS V20210708162818__Create_Applicant_education_details_view $$
CREATE PROCEDURE V20210708162818__Create_Applicant_education_details_view()
BEGIN

DROP VIEW IF EXISTS applicant_education_details_view;

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='applicant_education_details_view')) THEN 

CREATE 
     OR REPLACE ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `applicant_education_details_view` AS
    SELECT 
        `aeh`.`applicantPersonId` AS `applicantPersonId`,
        `ap`.`externalSysRefOne` AS `sunumber`,
        `app`.`code` AS `application_code`,
        `ap`.`firstName` AS `firstName`,
        `ap`.`lastName` AS `lastName`,
        `ap`.`printName` AS `printName`,
        `nat`.`itemValue` AS `Nationality`,
        (CASE
            WHEN (`exam`.`itemValue` = 'Gr 11') THEN `aeh`.`percentage`
            ELSE NULL
        END) AS `Gr_11_Average`,
        (CASE
            WHEN (`exam`.`itemValue` = 'Gr 12') THEN `aeh`.`percentage`
            ELSE NULL
        END) AS `Gr_12_Average`,
        `exam`.`itemValue` AS `Exam_Passed`,
        `aeh`.`examPassedId` AS `examPassedId`,
        `ebm`.`itemValue` AS `Exam_Board`,
        `aeh`.`enrollmentNumber` AS `enrollmentNumber`,
        `ed`.`itemValue` AS `Education_Department`,
        `cou`.`countryName` AS `countryName`,
        `coureg`.`countryRegionName` AS `countryRegionName`,
        `cty`.`cityName` AS `cityName`,
        `aeh`.`instituteName` AS `instituteName`,
        `cs`.`itemValue` AS `School`,
        `cs`.`itemCode` AS `School_Code`,
        `cs`.`classification` AS `classification`,
        `cs`.`quintile` AS `quintile`,
        `aeh`.`yearOfExam` AS `yearOfExam`,
        `aeh`.`monthOfExamination` AS `monthOfExamination`,
        `aeh`.`yearOfExamination` AS `yearOfExamination`,
        `sub`.`itemValue` AS `subject`,
        `asmi`.`marks` AS `marks`,
        `sub1`.`itemValue` AS `equvalentsubject`,
        `aeh`.`whetherDeleted` AS `status`,
        `asmi`.`lastUpdate` AS `lastUpdate`
    FROM
        (((((((((((((`applicant_subject_mark_info` `asmi`
        LEFT JOIN `applicant_education_histories` `aeh` ON (((`aeh`.`id` = `asmi`.`applicantEducationHistoryId`)
            AND (`aeh`.`whetherDeleted` = 0))))
        LEFT JOIN `subjects` `sub` ON ((`sub`.`id` = `asmi`.`subjectId`)))
        LEFT JOIN `applicant_person` `ap` ON ((`ap`.`id` = `aeh`.`applicantPersonId`)))
        LEFT JOIN `campaign_school` `cs` ON ((`cs`.`id` = `aeh`.`campaign_school_id`)))
        LEFT JOIN `exam_passed` `exam` ON ((`exam`.`id` = `aeh`.`examPassedId`)))
        LEFT JOIN `exam_board_master` `ebm` ON ((`ebm`.`id` = `aeh`.`examBoardId`)))
        LEFT JOIN `education_department` `ed` ON ((`ed`.`id` = `aeh`.`education_department_id`)))
        LEFT JOIN `country` `cou` ON ((`cou`.`id` = `aeh`.`country_id`)))
        LEFT JOIN `country_region` `coureg` ON ((`coureg`.`id` = `aeh`.`country_region_id`)))
        LEFT JOIN `city` `cty` ON ((`cty`.`id` = `aeh`.`city_id`)))
        LEFT JOIN `nationalities` `nat` ON ((`nat`.`id` = `ap`.`nationalityId`)))
        LEFT JOIN `application` `app` ON ((`app`.`applicantPersonId` = `ap`.`id`)))
        LEFT JOIN `subjects` `sub1` ON ((`sub`.`equivalentSubjectId` = `sub1`.`id`)))
    WHERE
        (`app`.`code` IS NOT NULL);

END IF; 

END $$
CALL V20210708162818__Create_Applicant_education_details_view () $$ 
DROP PROCEDURE IF EXISTS V20210708162818__Create_Applicant_education_details_view $$ 
DELIMITER ;