DELIMITER $$
DROP PROCEDURE IF EXISTS V20210714105955__Create_faculty_insurance_history_main $$
CREATE PROCEDURE V20210714105955__Create_faculty_insurance_history_main()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='faculty_insurance_his')) THEN 

CREATE TABLE `faculty_insurance_his` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `insuranceType` varchar(255) DEFAULT NULL,
  `insuranceProvider` varchar(255) DEFAULT NULL,
  `insuranceDate` date DEFAULT NULL,
  `sumInsured` decimal(10,2) DEFAULT NULL,
  `insuranceExpiryDate` date DEFAULT NULL,
  `whetherDeleted` tinyint(1) DEFAULT NULL,
  `lastUpdatedBy` bigint DEFAULT NULL,
  `lastUpdate` datetime NOT NULL,
  `version` bigint NOT NULL,
  `personId` bigint DEFAULT NULL,
  `updatedDate` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `REF_INS_HIS_USERS_ID` (`lastUpdatedBy`),
  KEY `REF_PERSON_PERSON_ID_idx` (`personId`),
  CONSTRAINT `REF_INS_HIS_USERS_ID` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT `REF_PERSON_INS_HIS_USERS_ID` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


END IF; 

END $$
CALL V20210714105955__Create_faculty_insurance_history_main () $$ 
DROP PROCEDURE IF EXISTS V20210714105955__Create_faculty_insurance_history_main $$ 
DELIMITER ;