DELIMITER $$
DROP PROCEDURE IF EXISTS V20210719150735__Alter_event_details $$
CREATE PROCEDURE V20210719150735__Alter_event_details()
BEGIN
DROP VIEW IF EXISTS `event_details`;
IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='event_details')) THEN 
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `event_details` AS
    SELECT DISTINCT
        `rb`.`id` AS `Event_ID`,
        `rb`.`eventName` AS `Event_Name`,
        `rb`.`eventDate` AS `eventDate`,
        `bp`.`value` AS `Event_purpose`,
        `rb`.`venue` AS `venue`,
        `rb`.`purpose` AS `Purpose_Detail`,
        `rb`.`eventDesc` AS `Event_Description`,
        `rb`.`bookedBy` AS `bookedBy`
    FROM
        (`resource_bookings` `rb`
        JOIN `booking_purposes` `bp` ON ((`bp`.`id` = `rb`.`bookingPurposeId`)))
        where (
                (
                    rb.purposeDescription <> 'Session' 
                ) 
                OR  (
                    rb.purposeDescription IS NULL 
                ) 
            )
            AND  (
                rb.eventName <> 'OTHEREVENT' 
            ) 
            AND  (
                rb.whetherDeleted <> TRUE 
            );
END IF; 

END $$
CALL V20210719150735__Alter_event_details() $$
DROP PROCEDURE IF EXISTS V20210719150735__Alter_event_details $$
DELIMITER ;