DELIMITER $$
DROP PROCEDURE IF EXISTS V20210802154127__Alter_MinMaxSubjectInExamBoard $$
CREATE PROCEDURE V20210802154127__Alter_MinMaxSubjectInExamBoard()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='exam_board_master' AND (column_name='maximumSubject' OR column_name='minimumSubject'))) THEN 
	ALTER TABLE `exam_board_master` 
	ADD COLUMN `maximumSubject` VARCHAR(20) NULL DEFAULT NULL AFTER `sequenceNo`,
	ADD COLUMN `minimumSubject` VARCHAR(20) NULL DEFAULT NULL AFTER `sequenceNo`;
END IF; 

SET @standardMasterId=(SELECT MAX(id) FROM standard_master where tableName='exam_board_master' AND masterName='EXAM_BOARD_MASTER');

IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE (dbFieldName = 'minimumSubject' OR dbFieldName = 'maximumSubject') AND standardMasterId = @standardMasterId)) THEN 
		 
	SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
	INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
	VALUES (@ItemsMaxId+1, 'minimumSubject', 'MINIMUM_SUBJECT', @standardMasterId, 'Number', '8', 0, 0, 0, 1, '1', SYSDATE());

	SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
	INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
	VALUES (@ItemsMaxId+1, 'maximumSubject', 'MAXIMUM_SUBJECT', @standardMasterId, 'Number', '9', 0, 0, 0, 1, '1', SYSDATE());

END IF;

END $$
CALL V20210802154127__Alter_MinMaxSubjectInExamBoard() $$
DROP PROCEDURE IF EXISTS V20210802154127__Alter_MinMaxSubjectInExamBoard $$
DELIMITER ;