DELIMITER $$
DROP PROCEDURE IF EXISTS V20210909112128__Create_studyprogram_details_view $$
CREATE PROCEDURE V20210909112128__Create_studyprogram_details_view()
BEGIN

DROP VIEW IF EXISTS studyprogram_details;
IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='studyprogram_details')) THEN 

CREATE 
     OR REPLACE ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `studyprogram_details` AS
    SELECT DISTINCT
        `al`.`academyCode` AS `Faculty_Code`,
        `prog`.`programCode` AS `Study_Program_Code`,
        `prog`.`programName` AS `Study_Program_Name`,
        `pg`.`groupName` AS `Study_Program_Group`,
        `prog`.`programMarkGrade` AS `Study_Program_Marks_Grades`,
        `mode`.`itemValue` AS `Mode_of_Delivery`,
        (CASE
            WHEN (`prog`.`status` = 'O') THEN 'Open'
            WHEN (`prog`.`status` = 'C') THEN 'Close'
            ELSE `prog`.`status`
        END) AS `status`,
        `prog`.`accreditationFromDate` AS `From_Date_of_Accreditation`,
        `prog`.`accreditationTillDate` AS `Till_Date_of_Accreditation`,
        (CASE
            WHEN (`prog`.`whetherAccreditation` = 1) THEN 1
            ELSE 0
        END) AS `Accreditation_of_Program`,
        `prog`.`accreditationProgramAccreditation` AS `Name_of_Accreditation_Agency`,
        `department`.`deptName` AS `Department Name`
       FROM
        ((((`programs` `prog`
        JOIN `academy_location` `al` ON ((`al`.`id` = `prog`.`academyLocationId`)))
        JOIN `program_group` `pg` ON ((`pg`.`id` = `prog`.`programGroupId`)))
        LEFT JOIN `mode_of_delivery` `mode` ON ((`mode`.`id` = `prog`.`modeOfDeliveryId`)))
        LEFT JOIN `department` ON ((`department`.`id` = `prog`.`programDepartmentId`)));

END IF; 

END $$
CALL V20210909112128__Create_studyprogram_details_view () $$ 
DROP PROCEDURE IF EXISTS V20210909112128__Create_studyprogram_details_view $$ 
DELIMITER ;