DELIMITER $$
DROP PROCEDURE IF EXISTS V20211013105611__Alter_ForAcademyTable $$
CREATE PROCEDURE V20211013105611__Alter_ForAcademyTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='academies' AND column_name in ('typeOfAgreementId','dateCompanySigned','dateFBCSigned'))) THEN 
ALTER TABLE `academies` 
ADD COLUMN `typeOfAgreementId` bigint(20) NULL AFTER `industryCategoryDes`,
ADD COLUMN `dateCompanySigned` date NULL AFTER `typeOfAgreementId`,
ADD COLUMN `dateFBCSigned` date NULL AFTER `dateCompanySigned`,
ADD CONSTRAINT typeOfAgreementId_id_ref 
    FOREIGN KEY (typeOfAgreementId)
    REFERENCES placement_type_of_agreement(id);

END IF; 


IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PLACEMENT' and keyName='TYPE_OF_AGREEMENT')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PLACEMENT','TYPE_OF_AGREEMENT','Type of agreement','Type of agreement','Soort ooreenkoms', 'Loại thỏa thuận',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PLACEMENT' and keyName='DATE_COMPANY_SIGNED')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PLACEMENT','DATE_COMPANY_SIGNED','Date Company Signed','Date Company Signed','Datum Maatskappy Onderteken', 'Ngày công ty đã ký',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PLACEMENT' and keyName='DATE_FBC_SIGNED')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PLACEMENT','DATE_FBC_SIGNED','Date FBC Signed','Date FBC Signed','Datum FBC Onderteken', 'Ngày ký FBC',now(),1);
END IF; 
 

END $$
CALL V20211013105611__Alter_ForAcademyTable() $$
DROP PROCEDURE IF EXISTS V20211013105611__Alter_ForAcademyTable $$
DELIMITER ;