DELIMITER $$
DROP PROCEDURE IF EXISTS V20211018200458__Insert_reportTemplate $$
CREATE PROCEDURE V20211018200458__Insert_reportTemplate()
BEGIN

IF NOT EXISTS ((select * from report_template where templateCode = 'SAMHS_PROGRESS_REPORT_EXCEL')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `templateType`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES ('2', 'SAMHS_PROGRESS_REPORT_EXCEL', 'SAMHS Progress Report - Excel', 'SAMHS_PROGRESS_REPORT_EXCEL.png', 'CommonReport_Excel_SAMHS.jasper', 'EVALUATION_PLAN', 'All', '1', 'Header_Excel.jasper', 'Footer_Excel.jasper', '1', '1', 'SAMHS_PROGRESS_REPORT_EXCEL.jasper', 'AcademiaLogo.png');
END IF; 	
	
IF EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'SAMHS_PROGRESS_REPORT_EXCEL')) THEN 

set @reportTempId = (select max(id) from report_template where templateCode='SAMHS_PROGRESS_REPORT_EXCEL');

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`) 
VALUES (@reportTempId, 'TRANS_PROGRESS_REPORT_CARD', 'Progress Report Card', '1'),
(@reportTempId, 'TRANS_PERSONAL_DETAILS', 'Personal Details', '1'),
(@reportTempId, 'TRANS_FORCE_NUMBER', 'Force Number:', '1'),
(@reportTempId, 'TRANS_RANK', 'Rank:', '1'),
(@reportTempId, 'TRANS_NAME', 'Name:', '1'),
(@reportTempId, 'TRANS_ID_NUMBER', 'Id Number:', '1'),
(@reportTempId, 'TRANS_SANC_NUMBER', 'SANC Number:', '1'),
(@reportTempId, 'TRANS_QUALIFICATION_DETAILS', 'Qualification Details', '1'),
(@reportTempId, 'TRANS_PROGRAM_NUMBER', 'Program Number:', '1'),
(@reportTempId, 'TRANS_DESCRIPTION', 'Description:', '1'),
(@reportTempId, 'TRANS_INTAKE', 'Intake:', '1'),
(@reportTempId, 'TRANS_PERIOD', 'Period:', '1'),
(@reportTempId, 'TRANS_LEARNING', 'Learning Programme Details', '1'),
(@reportTempId, 'TRANS_ALLOCATION_OF_MARKS', 'ALLOCATION OF MARKS', '1'),
(@reportTempId, 'TRANS_MODULE_NAME', 'MODULE NAME', '1'),
(@reportTempId, 'TRANS_POSSIBLE', 'Possible\n(Max Mark)', '1'),
(@reportTempId, 'TRANS_REQUIRED', 'Required\n(Min Mark)', '1'),
(@reportTempId, 'TRANS_ACHIEVED', 'Achieved\n(Mark Obtain)', '1'),
(@reportTempId, 'TRANS_MODULE_RESULT', 'Module Result', '1'),
(@reportTempId, 'TRANS_REMARK', 'Remark', '1'),
(@reportTempId, 'TRANS_TOTAL', 'TOTAL', '1'),
(@reportTempId, 'TRANS_AVERAGE', 'AVERAGE', '1'),
(@reportTempId, 'TRANS_REMARKS', 'REMARKS', '1'),
(@reportTempId, 'TRANS_OFFICER', 'OFFICER COMMANDING SAMHS NURSING COLLEGE:', '1'),
(@reportTempId, 'TRANS_DATE', 'DATE:', '1');

END IF; 

END $$
CALL V20211018200458__Insert_reportTemplate() $$
DROP PROCEDURE IF EXISTS V20211018200458__Insert_reportTemplate $$
DELIMITER ;