DELIMITER $$
DROP PROCEDURE IF EXISTS student_receipt_till_date$$
CREATE PROCEDURE student_receipt_till_date(IN studentIds VARCHAR(15000))
BEGIN

SELECT 
    rh.studentId,
    concat(c.currencyCode,' ',SUM(rh.amount))
FROM
    receipt_header AS rh
        LEFT OUTER JOIN
    currency AS c ON c.id = rh.currencyId
WHERE
   FIND_IN_SET(rh.studentId, studentIds)
        AND rh.status <> 'CANCELLED'
GROUP BY rh.studentId;


END $$
DELIMITER ;

