DELIMITER $$

DROP PROCEDURE IF EXISTS V20212204150930__AlterPostStudyAddStatusColumn $$

CREATE PROCEDURE V20212204150930__AlterPostStudyAddStatusColumn()

BEGIN

	IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='post_school_studies_section' AND column_name='certificate_doc_status')) THEN 
	  ALTER TABLE `post_school_studies_section` 
	  ADD COLUMN `certificate_doc_status` BIGINT(20) NULL DEFAULT NULL AFTER certificate_path,
	  ADD INDEX `fk_post_school_certificate_doc_status_idx` (`certificate_doc_status` ASC);
	
		set foreign_key_checks=0;
		ALTER TABLE `post_school_studies_section` 
		ADD CONSTRAINT `fk_post_school_certificate_doc_status_id`
		FOREIGN KEY (`certificate_doc_status`)
		REFERENCES `document_status` (`id`)
		ON DELETE NO ACTION
		ON UPDATE NO ACTION;
		set foreign_key_checks=1;
	
	END IF;
	
	IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='post_school_studies_section' AND column_name='transcript_doc_status')) THEN 
	  ALTER TABLE `post_school_studies_section` 
	  ADD COLUMN `transcript_doc_status` BIGINT(20) NULL DEFAULT NULL AFTER certificate_doc_status,
	  ADD INDEX `fk_post_school_transcript_doc_status_idx` (`transcript_doc_status` ASC);
	
		set foreign_key_checks=0;
		ALTER TABLE `post_school_studies_section` 
		ADD CONSTRAINT `fk_post_school_transcript_doc_status_id`
		FOREIGN KEY (`transcript_doc_status`)
		REFERENCES `document_status` (`id`)
		ON DELETE NO ACTION
		ON UPDATE NO ACTION;
		set foreign_key_checks=1;
	
	END IF;


END $$

CALL V20212204150930__AlterPostStudyAddStatusColumn() $$

DROP PROCEDURE IF EXISTS V20212204150930__AlterPostStudyAddStatusColumn $$

DELIMITER ;