DELIMITER $$
DROP procedure IF EXISTS `student_finacial_summary_till_date`$$
DROP procedure IF EXISTS `student_receipt_till_date`$$

CREATE  PROCEDURE `student_finacial_summary_till_date`(IN studentIds VARCHAR(255))
BEGIN
DECLARE outstanding VARCHAR(255) DEFAULT '';
DECLARE totalBill VARCHAR(255) DEFAULT '';


SELECT 
    CONCAT(c.currencyCode,' ',SUM(bfprs.balanceAmount)) AS balanceAmount INTO outstanding
FROM
    bill_fee_plan_rule_stage AS bfprs
        LEFT OUTER JOIN
    bill_header AS bh ON bh.id = bfprs.billId
        LEFT OUTER JOIN
    currency c ON bh.currencyId = c.id
WHERE
    FIND_IN_SET(bh.studentId, studentIds)
        AND bh.billStatus <> 'CANCELLED'
        AND bh.raiseBillCategory = 'BILL_RECEIVABLE'
        AND bfprs.balanceAmount > 0
GROUP BY bh.studentId;


SELECT outstanding,totalBill;

END$$
DELIMITER ;

